package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


    /**
     *
     * @TableName base_inventory_box_mark
     */
@TableName(value ="base_inventory_box_mark")
@Data
public class InventoryBoxMark implements Serializable {
    /**
     *
     */
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * epc
     */
    @TableField(value = "epc")
    private String epc;

    /**
     * 箱内数量
     */
    @TableField(value = "one_box_num")
    private Integer oneBoxNum;

    /**
     * 类型id
     */
    @TableField(value = "equipment_detail_id")
    private String equipmentDetailId;

    /**
     * 号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 供应商id
     */
    @TableField(value = "supplier_id")
    private String supplierId;

    /**
     * 状态
     */
    @TableField(value = "current_state")
    private Integer currentState;

    /**
     * 仓库id
     */
    @TableField(value = "warehouse_id")
    private String warehouseId;

    /**
     * 重装箱状态，0：未重装箱，1：未打印，2：已打印
     */
    @TableField(value = "reload_boxing_state")
    private Integer reloadBoxingState;

    /**
     * 旧版epc
     */
    @TableField(value = "old_epc")
    private String oldEpc;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}
