package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName base_device_config
 */
@TableName(value ="base_device_config")
@Data
public class DeviceConfig implements Serializable {
    /**
     * id
     */

    private String id;

    /**
     * 设备名称
     */
    @TableField(value = "device_name")
    private String deviceName;

    /**
     * 设备编号
     */
    @TableField(value = "device_code")
    private String deviceCode;

    /**
     * 设备状态（0异常1正常）
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 位置
     */
    @TableField(value = "position")
    private String position;

    /**
     * 仓库id
     */
    @TableField(value = "location_id")
    private String locationId;

    /**
     * 日常日志信息
     */
    @TableField(value = "error_log")
    private String errorLog;

    /**
     * 设备配置信息
     */
    @TableField(value = "device_config")
    private String deviceConfig;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 类型：0通道1仓库主机
     */
    @TableField(value = "device_type")
    private Integer deviceType;
    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 创建人
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 更新人
     */
    @TableField(value = "update_user")
    private String updateUser;

    @TableField(exist = false)
    private String locationName;

    @TableField(exist = false)
    private String orgName;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}