package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@TableName(value ="base_cabinet_outinlog")
@Data
public class CabinetOutinlog implements Serializable {
    /**
     * id
     */
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 创建时间（用于分区）
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 状态
     */
    @TableField(value = "state")
    private String state;

    /**
     * 操作人
     */
    @TableField(value = "user_name")
    private String userName;

    /**
     * 箱门号
     */
    @TableField(value = "box_no")
    private Integer boxNo;

    @TableField(exist = false)
    private String boxName;

    /**
     * 装备名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 照片
     */
    @TableField(value = "photo")
    private String photo;

    /**
     * epc
     */
    @TableField(value = "epc")
    private String epc;

    /**
     * 主柜号编号
     */
    @TableField(value = "dev_sn")
    private String devSn;

    /**
     * 推送时间
     */
    @TableField(value = "push_time")
    private Date pushTime;

    /**
     * 操作时间
     */
    @TableField(value = "operation_time")
    private Date operationTime;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    @TableField(exist = false)
    private String cabinetName;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
