package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

@TableName(value ="base_cabinet_inv_error_msg")
@Data
public class CabinetInvErrorMsg {
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 主柜编号
     */
    @TableField(value = "dev_sn")
    private String devSn;

    /**
     * 位置信息
     */
    @TableField(value = "location")
    private String location;

    /**
     * 箱门号
     */
    @TableField(value = "box_no")
    private Integer boxNo;

    /**
     * 箱门id
     */
    @TableField(value = "box_id")
    private String boxId;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 错误类型
     */
    @TableField(value = "state")
    private String state;

    /**
     * 错误日志
     */
    @TableField(value = "msg")
    private String msg;

    /**
     * 操作时间
     */
    @TableField(value = "push_time")
    private Date pushTime;

    /**
     * 操作人
     */
    @TableField(value = "user_name")
    private String userName;

    /**
     * 原来警员（错还使用）
     */
    @TableField(value = "current_user_name")
    private String currentUserName;

    /**
     * epc
     */
    @TableField(value = "epc")
    private String epc;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}
