package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName base_cabinet_box_equipment
 */
@TableName(value ="base_cabinet_box_equipment")
@Data
public class CabinetBoxEquipment implements Serializable {
    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * epc
     */
    private String epc;

    /**
     * 组织机构id
     */
    private String orgId;

    /**
     * 箱门id
     */
    private String locationId;

    /**
     * 设备编号
     */
    private String devSn;

    /**
     * 装备状态（in在柜，out出柜）
     */
    private String locationState;

    /**
     * 装备类型id
     */
    private String typeId;

    /**
     * 装备号型id
     */
    private String sizeId;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * epc类型（0为固定资产，1为库存物资非固定资产）
     */
    private Integer property;

    /**
     * 装备状态（0绑定，1解绑）
     */
    private Integer equipmentState;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}