package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-CabinetBox")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_cabinet_box")
public class CabinetBox implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    @ApiModelProperty(value = "主键ID")
    private String id;

    /**
     * 智能柜本地设主键编号
     */
    @TableField(value = "box_local_id")
    private String boxLocalId;

    /**
     * 主柜ID
     */
    @ApiModelProperty(value = "主柜ID")
    @TableField("cabinet_id")
    private String cabinetId;

    /**
     * 箱门编号
     */
    @ApiModelProperty(value = "箱号")
    @TableField("box_no")
    private Integer boxNo;

    /**
     * 装备配置信息
     */
    @ApiModelProperty(value = "装备配置信息")
    @TableField("equipment_config")
    private String equipmentConfig;

    /**
     * 功率
     */
    @ApiModelProperty(value = "power")
    @TableField("power")
    private String power;
    /**
     * 异常状态:1正常/0异常
     */
    @ApiModelProperty(value = "异常状态:1正常/0异常")
    private Integer state;

    /**
     * 异常原因
     */
    @ApiModelProperty(value = "异常原因")
    @TableField("error_msg")
    private String errorMsg;
    /**
     * 别名
     */
    @ApiModelProperty(value = "别名")
    @TableField("box_name")
    private String boxName;
    /**
     * 箱门类型：1单警柜，2公共柜
     */
    @ApiModelProperty(value = "箱门类型：1单警柜，2公共柜")
    @TableField("contain_type")
    private Integer containType;
    /**
     * 使用日志存储位置信息
     */
    @ApiModelProperty(value = "使用日志存储位置信息")
    @TableField("log_map")
    private String logMap;

    @TableField(fill = FieldFill.INSERT_UPDATE, value = "create_time")
    private Date createTime;

    @TableField(fill = FieldFill.INSERT_UPDATE, value = "update_time")
    private Date updateTime;

    @TableField(exist = false)
    private String locationName;

}
