package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;


@TableName(value ="bussiness_inventory_detail")
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class BussinessDetail implements Serializable {
    /**
     * id
     */
    @TableId(value = "id")
    @Id
    private Long id;

    /**
     * 主单id
     */
    @TableField(value = "inventory_id")
    private Long inventoryId;
    /**
     * 工作流id
     */
    @TableField(value = "group_id")
    private String groupId;
    /**
     * 类型id
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 类型名称
     */
    @TableField(value = "type_name")
    private String typeName;

    /**
     * 是否已人工改账，0未改，1已改，如果人工添加数量为0，则生成时属于已改状态
     */
    @TableField(value = "has_count")
    private Integer hasCount;
    /**
     * 号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 号型名称
     */
    @TableField(value = "size_name")
    private String sizeName;

    /**
     * 在库数（包含报废区）
     */
    @TableField(value = "stock_number")
    private Integer stockNumber;
    /**
     * 在库金额
     */
    @TableField(value = "stock_price")
    private BigDecimal stockPrice;

    /**
     * 单价
     */
    @TableField(value = "price")
    private BigDecimal price;
    /**
     * 修正后的在库金额
     */
    @TableField(value = "fix_price")
    private BigDecimal fixPrice;
    /**
     * 修正后的在库数量
     */
    @TableField(value = "fix_number")
    private Integer fixNumber;

    /**
     * 金额差距数量
     */
    @TableField(value = "num")
    private Integer num;
    /**
     * 状态.0正常，1盈余，2亏损
     */
    @TableField(value = "state")
    private String state;
    /**
     * 人工添加数量
     */
    @TableField(value = "account_num")
    private String accountNum;

    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;



    private static final long serialVersionUID = 1L;

}