package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 
 * @TableName sys_application
 */
@TableName(value ="sys_application")
@Data
public class Application implements Serializable  {
    /**
     * 应用id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 应用代码
     */
    @TableField("app_code")
    private String appCode;

    /**
     * 版本号
     */
    private String version;

    /**
     * 应用名称
     */
    private String name;

    /**
     * 类型（0内部软件管理，1外部软件管理，2插件/环境安装包，3导出模板维护，4导入模板维护）
     */
    private Integer type;

    /**
     * 应用地址
     */
    private String address;

    /**
     * 备注
     */
    private String note;

    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;

    private String version2;

    @TableField(value = "file_md5")
    private String fileMd5;

    @TableField(value = "is_auto_update")
    private Integer isAutoUpdate;

    @TableField(value = "auto_update_address")
    private String autoUpdateAddress;

    @TableField(value = "auto_update_file_md5")
    private String autoUpdateFileMd5;

    @TableField(value = "auto_update_version2")
    private String autoUpdateVersion2;

    private static final long serialVersionUID = 1L;



}