package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.fetchingDataDto.SupplierInfoDto;
import com.junmp.jyzb.api.bean.dto.SupplierDto;
import com.junmp.jyzb.api.bean.query.QuerySupplierReq;
import com.junmp.jyzb.api.bean.req.UpdateSupplierReq;
import com.junmp.jyzb.entity.Supplier;
import com.junmp.jyzb.service.SupplierService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Supplier")
@Api(tags = "[基础信息]供应商基础信息模块")
public class SupplierController {
    @Resource
    public SupplierService supplierService;

    @PostMapping(path="/AddSupplier",name="添加供应商#logType=30")
    @ApiOperation("添加供应商")
    public ApiRes<String> AddSupplier(@RequestBody @Validated(ValidationApi.add.class) UpdateSupplierReq req) {
        return ApiRes.success(supplierService.AddSupplier(req));
    }

    @PostMapping(path="/DeleteSupplier",name="删除供应商信息#logType=30")
    @ApiOperation("删除供应商信息")
    public ApiRes<Boolean> DeleteSupplier(@RequestBody @Validated(ValidationApi.delete.class) UpdateSupplierReq req) {
        return ApiRes.success(supplierService.DeleteSupplier(req));
    }


    @PostMapping(path="/ShowSupplier",name="查询供应商列表#enable")
    @ApiOperation("查询供应商列表")
    public ApiRes<List<SupplierDto>> ShowSupplier(@RequestBody QuerySupplierReq req){
        return ApiRes.success(supplierService.ShowSupplier(req));
    }

    //供应商分页

    @PostMapping(path="/ShowSupplierPage",name="查询供应商列表#enable")
    @ApiOperation("查询供应商列表(page)")
    public ApiRes<PageResult<Supplier>> ShowSupplierPage(@RequestBody QuerySupplierReq req){
        return ApiRes.success(supplierService.ShowSupplierPage(req));
    }



    @PostMapping(path="/UpdateSupplier",name="修改供应商信息#logType=30")
    @ApiOperation("修改供应商信息")
    public ApiRes<Boolean> updateSupplier(@RequestBody @Validated(ValidationApi.edit.class) UpdateSupplierReq req) {
        return ApiRes.success(supplierService.UpdateSupplier(req));
    }

    @PostMapping(path="/ChangeSupplierState",name="修改供应商状态#logType=30")
    @ApiOperation("修改供应商状态")
    public ApiRes<Boolean> changeSupplierState(@RequestBody @Validated(ValidationApi.edit.class) UpdateSupplierReq req) {
        return ApiRes.success(supplierService.ChangeSupplierState(req));
    }

    @PostMapping(path="/alignSupplierInfo",name="同步更新号型信息#enable")
    @ApiOperation("同步更新号型信息")
    public ApiRes<List<SupplierInfoDto>> alignSupplierInfo(@RequestBody UpdateSupplierReq req){
        return ApiRes.success(supplierService.alignSupplierInfo(req));
    }
}
