package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.PlanTemplateItemDto;
import com.junmp.jyzb.api.bean.req.PlanModuleReq;
import com.junmp.jyzb.api.bean.req.PlanTemplateReq;
import com.junmp.jyzb.entity.PlanModule;
import com.junmp.jyzb.entity.PlanTemplate;
import com.junmp.jyzb.entity.PlanTemplateItem;
import com.junmp.jyzb.service.PlanTemplateService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 *
 * 描述：预案模块管理
 * 版本：1.0.0
 * 日期：2024/6/2 16:01
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Slf4j
@RestController
public class PlanTemplateController {
    @Resource
    private PlanTemplateService planTemplateService;

    /**
     * 分页查询预案信息
     * @param req
     * @return
     */
    @PostMapping("/template/getPage")
    public ApiRes<PageResult<PlanTemplate>> getPage(@RequestBody PlanTemplateReq req) {
        return ApiRes.success(planTemplateService.getPage(req));
    }

    /**
     * 查询预案信息集合
     * @param req
     * @return
     */
    @PostMapping("/template/getList")
    public ApiRes<List<PlanTemplate>> getList(@RequestBody PlanTemplateReq req) {
        return ApiRes.success(planTemplateService.getList(req));
    }

    /**
     * 查询预案信息详情
     * @param req
     * @return
     */
    @PostMapping("/template/getDetail")
    public ApiRes<List<PlanTemplateItem>> getDetail(@RequestBody @Validated(ValidationApi.detail.class) PlanTemplateReq req) {
        return ApiRes.success(planTemplateService.getDetail(req));
    }

    /**
     * 添加预案信息
     * @param req
     * @return
     */
    @PostMapping("/template/add")
    public ApiRes<Boolean> add(@RequestBody @Validated(ValidationApi.add.class) PlanTemplateReq req) {
        return ApiRes.success(planTemplateService.add(req));
    }

    /**
     * 更新预案信息
     * @param req
     * @return
     */
    @PostMapping("/template/edit")
    public ApiRes<Boolean> edit(@RequestBody @Validated(ValidationApi.edit.class) PlanTemplateReq req) {
        return ApiRes.success(planTemplateService.edit(req));
    }

    /**
     * 删除预案信息
     * @param req
     * @return
     */
    @PostMapping("/template/remove")
    public ApiRes<Boolean> remove(@RequestBody @Validated(ValidationApi.delete.class) PlanTemplateReq req) {
        return ApiRes.success(planTemplateService.delete(req));
    }
}
