package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.PlanModuleReq;
import com.junmp.jyzb.entity.PlanModule;
import com.junmp.jyzb.service.PlanModuleService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/6/2 15:25
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Slf4j
@RestController
public class PlanModuleController {
    @Resource
    private PlanModuleService planModuleService;

    /**
     * 分页查询模块信息
     * @param req
     * @return
     */
    @PostMapping("/module/getPage")
    public ApiRes<PageResult<PlanModule>> getPage(@RequestBody PlanModuleReq req) {
        return ApiRes.success(planModuleService.getPage(req));
    }

    /**
     * 查询模块信息集合
     * @param req
     * @return
     */
    @PostMapping("/module/getList")
    public ApiRes<List<PlanModule>> getList(@RequestBody PlanModuleReq req) {
        return ApiRes.success(planModuleService.getList(req));
    }

    /**
     * 添加模块信息
     * @param req
     * @return
     */
    @PostMapping("/module/add")
    public ApiRes<Boolean> add(@RequestBody @Validated(ValidationApi.add.class) PlanModuleReq req) {
        return ApiRes.success(planModuleService.add(req));
    }

    /**
     * 更新模块信息
     * @param req
     * @return
     */
    @PostMapping("/module/edit")
    public ApiRes<Boolean> edit(@RequestBody @Validated(ValidationApi.edit.class) PlanModuleReq req) {
        return ApiRes.success(planModuleService.edit(req));
    }

    /**
     * 删除模块信息
     * @param req
     * @return
     */
    @PostMapping("/module/remove")
    public ApiRes<Boolean> remove(@RequestBody @Validated(ValidationApi.delete.class) PlanModuleReq req) {
        return ApiRes.success(planModuleService.delete(req));
    }

}
