package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.PlanInitiationReq;
import com.junmp.jyzb.api.bean.req.PlanTemplateReq;
import com.junmp.jyzb.api.bean.vo.PlanInitTypeVo;
import com.junmp.jyzb.api.bean.vo.PlanTypeVo;
import com.junmp.jyzb.entity.PlanInitiation;
import com.junmp.jyzb.entity.PlanInitiationItem;
import com.junmp.jyzb.entity.PlanTemplate;
import com.junmp.jyzb.entity.PlanTemplateItem;
import com.junmp.jyzb.service.PlanInitiationService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <pre>
 *
 * 描述：发起预案管理
 * 版本：1.0.0
 * 日期：2024/6/2 16:43
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Slf4j
@RestController
public class PlanInitiationController {
    @Resource
    private PlanInitiationService planInitiationService;

    /**
     * 分页查询发起预案信息
     * @param req
     * @return
     */
    @PostMapping("/initiation/getPage")
    public ApiRes<PageResult<PlanInitiation>> getPage(@RequestBody PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.getPage(req));
    }

    /**
     * 查询发起预案信息集合
     * @param req
     * @return
     */
    @PostMapping("/initiation/getList")
    public ApiRes<List<PlanInitiation>> getList(@RequestBody PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.getList(req));
    }

    /**
     * 根据装备获取其库存信息
     * @param req
     * @return
     */
    @PostMapping("/initiation/getDetailList")
    public ApiRes<List<PlanInitTypeVo>> getDetailList(@RequestBody @Validated(PlanInitiationReq.getDetailList.class) PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.getDetailList(req));
    }

    /**
     * 查询发起预案信息详情
     * @param req
     * @return
     */
    @PostMapping("/initiation/getDetail")
    public ApiRes<PlanInitiation> getDetail(@RequestBody @Validated(ValidationApi.detail.class) PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.getDetail(req));
    }

    /**
     * 编辑时调用的：
     *       查询发起预案单信息详情
     * @param req
     * @return
     */
    @PostMapping("/initiation/getPlanDetail")
    public ApiRes<List<PlanInitTypeVo>> getPlanDetail(@RequestBody @Validated(PlanInitiationReq.onlyPlanId.class) PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.getPlanDetail(req));
    }

    /**
     * 添加发起预案信息
     * @param req
     * @return
     */
    @PostMapping("/initiation/add")
    public ApiRes<Boolean> add(@RequestBody @Validated(ValidationApi.add.class) PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.add(req));
    }

    /**
     * 更新发起预案信息
     * @param req
     * @return
     */
    @PostMapping("/initiation/edit")
    public ApiRes<Boolean> edit(@RequestBody @Validated(ValidationApi.edit.class) PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.edit(req));
    }

    /**
     * 删除发起预案信息
     * @param req
     * @return
     */
    @PostMapping("/initiation/remove")
    public ApiRes<Boolean> remove(@RequestBody @Validated(ValidationApi.delete.class) PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.delete(req));
    }
    /**
     * 更改预案状态（手动设置完成）
     */
    @PostMapping("/initiation/updateToFinished")
    public ApiRes<Boolean> updateToFinished(@RequestBody @Validated(PlanInitiationReq.onlyPlanId.class) PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.updateToFinished(req));
    }

    /**
     * 下发（生成领用单）
     * @param req
     * @return
     */
    @PostMapping("/initiation/createUseOrder")
    public ApiRes<Boolean> createUseOrder(@RequestBody @Validated(PlanInitiationReq.onlyPlanId.class) PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.createUseOrder(req));
    }
    /**
     * 归还（一键生成归还单，如果自己手动创建的归还单，那么直接再进行创建）
     */
    @PostMapping("/initiation/createReturnOrder")
    public ApiRes<Boolean> createReturnOrder(@RequestBody @Validated(PlanInitiationReq.onlyPlanId.class) PlanInitiationReq req) {
        return ApiRes.success(planInitiationService.createReturnOrder(req));
    }


}
