package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.OrderV2Dto;
import com.junmp.jyzb.api.bean.query.OrderV2Req;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.service.OrderV2Service;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/OrderV2")
@Api(tags = "2.0单据查看模块")
public class OrderV2Controller {
    @Resource
    private OrderV2Service orderV2Service;
    //查看单据
    @ApiOperation("查看单据")
    @PostMapping("/getOrderPageV2")
    public ApiRes<PageResult<OrderV2Dto>> getOrderPageV2(@RequestBody @Validated(ValidationApi.list.class) OrderV2Req req){
        return ApiRes.success(orderV2Service.getOrderPageV2(req));
    }
    //查看详情
    @ApiOperation("查看采购详情")
    @PostMapping("/getPurchaseDetail")
    public ApiRes<List<JpPurchaseDetail>> getPurchaseDetail(@RequestBody @Validated(ValidationApi.list.class) JpPurchaseDetail req){
        return ApiRes.success(orderV2Service.getPurchaseDetail(req));
    }


    @ApiOperation("查看借用,领用,销毁详情")
    @PostMapping("/getBorrowReturnDetail")
    public ApiRes<List<JpBorrowReturnDetail>> getBorrowReturnDetail(@RequestBody @Validated(ValidationApi.list.class)JpBorrowReturnDetail req){
        return ApiRes.success(orderV2Service.getBorrowReturnDetail(req));
    }

    @ApiOperation("查看调拨详情")
    @PostMapping("/getTransferDetail")
    public ApiRes<List<JpTransferDetail>> getTransferDetail(@RequestBody @Validated(ValidationApi.list.class)JpTransferDetail req){
        return ApiRes.success(orderV2Service.getTransferDetail(req));
    }


    @ApiOperation("查看维修,报废详情")
    @PostMapping("/getFixUselessDetail")
    public ApiRes<List<JpFixUselessDetail>> getFixUselessDetail(@RequestBody @Validated(ValidationApi.list.class)JpFixUselessDetail req){
        return ApiRes.success(orderV2Service.getFixUselessDetail(req));
    }

    @ApiOperation("查看无单号详情")
    @PostMapping("/getNoBorrowDetail")
    public ApiRes<List<JpNoborrowDetail>> getNoBorrowDetail(@RequestBody @Validated(ValidationApi.list.class)JpNoborrowDetail req){
        return ApiRes.success(orderV2Service.getNoBorrowDetail(req));
    }

}
