package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.OrderDto;
import com.junmp.jyzb.api.bean.dto.OrderMainDto;
import com.junmp.jyzb.api.bean.dto.OrderPrintNumDto;
import com.junmp.jyzb.api.bean.dto.ProcessOrderDto;
import com.junmp.jyzb.api.bean.query.OrderMainReq;
import com.junmp.jyzb.api.bean.query.OrderUploadReq;
import com.junmp.jyzb.api.bean.query.QueryOrderLogReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.entity.OrderLog;
import com.junmp.jyzb.service.OrderMainService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Order")
@Api(tags = "[业务]业务模块")
public class OrderController {
    @Resource
    public OrderMainService orderMainService;


    //通过工作流进行操作处理的
    @PostMapping(path="/AddOrder",name="新增任务单#logType=30")
    @ApiOperation("新增任务单")
    public ApiRes<List<String>> addOrder(@RequestBody UpdateOrderReq req) {

        return ApiRes.success(orderMainService.AddOrder(req));
    }

    @PostMapping(path = "/delToSubmitOrder",name = "删除待提交的出入库单据#logType=30")
    @ApiOperation("删除待提交的出入库单据")
    public ApiRes<Boolean> delToSubmitOrder(@RequestBody @Validated(ValidationApi.delete.class) UpdateOrderReq req){
        return ApiRes.success(orderMainService.delToSubmitOrder(req));
    }


    @PostMapping(path = "/updateOrderOpenState",name = "修改单据是否开启#logType=30")
    @ApiOperation("修改单据是否开启")
    public ApiRes<Map<String,Boolean>> updateOrderOpenState(@RequestBody UpdateOrderReq req){

        return ApiRes.success(orderMainService.updateOrderOpenState(req));
    }


    //内部处理，任务单状态直接设置成finished 添加到数据并且直接推送到消息队列中去
    @PostMapping(path="/AddFinishOrder",name="新增已完成的任务单#logType=30")
    @ApiOperation("新增已完成的任务单")
    public ApiRes<String> AddFinishOrder(@RequestBody UpdateOrderReq req)  {

        return ApiRes.success(orderMainService.AddFinishOrder(req));
    }


    //修改任务单只允许工作流id为空的时候（视为草稿可以进行修改）
//    @PostMapping("/UpdateOrder")
//    @ApiOperation("修改任务单")
//    public ApiRes<Boolean>  updateOrder(@RequestBody @Validated(ValidationApi.edit.class) UpdateOrderReq req) {
//        return ApiRes.success(orderMainService.updateOrder(req));
//    }


    //查询任务列表(根据组织机构id)
    @PostMapping(path="/GetOrderPage",name="查询任务列表#enable")
    @ApiOperation("/查询任务列表")
    public ApiRes<PageResult<OrderMainDto>> getOrderPage(@RequestBody @Validated(ValidationApi.add.class)OrderMainReq req ){
        return ApiRes.success(orderMainService.getOrderPage(req));
    }

    @PostMapping(path="/GetDetailById",name="根据任务单id查看业务明细#enable")
    @ApiOperation("根据任务单id查看业务明细")
    public ApiRes<OrderDto> GetDetailById(@RequestBody @Validated(ValidationApi.detail.class) OrderMainReq req){
        return ApiRes.success(orderMainService.GetDetailById(req));
    }

    @PostMapping(path="/PushState",name="单据状态上报#logType=30")
    @ApiOperation("单据状态上报")
    public ApiRes<Boolean> PushState(@RequestBody @Validated(ValidationApi.delete.class) OrderUploadReq req){
        return ApiRes.success(orderMainService.PushState(req));
    }

    //记账完成之后往消息队列推送消息表示该单子已经完成结算
    @PostMapping(path="/Accounting",name="记账#logType=30")
    @ApiOperation("记账")
    public ApiRes<Boolean> Accounting(@RequestBody @Validated(ValidationApi.delete.class) UpdateOrderReq req){
//        boolean accounting = orderMainService.Accounting(req);
        boolean accounting = orderMainService.testAccounting(req);
        System.out.println("accounting = " + accounting);
        return ApiRes.success(accounting);
    }

    @PostMapping(path="/TestAccounting",name="记账#logType=30")
    @ApiOperation("记账")
    public ApiRes<Boolean> testAccounting(@RequestBody @Validated(ValidationApi.delete.class) UpdateOrderReq req){
        return ApiRes.success(orderMainService.testAccounting(req));
    }


    @PostMapping(path="/ShowAccountingPage",name="查看记账列表#enable")
    @ApiOperation("查看记账列表")
    public ApiRes<PageResult<OrderLog>> ShowAccountingPage(@RequestBody QueryOrderLogReq req){
        return ApiRes.success(orderMainService.ShowAccountingPage(req));
    }

    //入库单导出
    @PostMapping(path="/InOrderExport",name="入库单导出#enable")
    @ApiOperation("入库单导出")
    public void InOrderExport(@RequestBody OrderMainReq req){
        orderMainService.InOrderExport(req);
    }

    //出库单导出
    @PostMapping(path="/OutOrderExport",name="出库单导出#enable")
    @ApiOperation("出库单导出")
    public void OutOrderExport(@RequestBody OrderMainReq req){
        orderMainService.OutOrderExport(req);
    }


    //根据流程id获取单据的装备信息
    @PostMapping(path="/GetByProcessId",name="根据流程id获取单据装备信息#enable")
    @ApiOperation("根据流程id获取单据装备信息")
    public ApiRes<ProcessOrderDto> GetByProcessId(@RequestBody OrderMainReq req){
        return ApiRes.success(orderMainService.GetByProcessId(req));
    }

    @PostMapping(path = "/GetInvsListByOrder",name = "拿取单据下的所有装备#enable")
    @ApiOperation("拿取单据下的所有装备")
    public ApiRes<List<String>> getInvsListByOrder(@RequestBody OrderMainReq req){
        return ApiRes.success(orderMainService.getInvsListByOrder(req));
    }

    @PostMapping(path ="/getPrintCode",name = "获取打印单号#logType=30")
    @ApiOperation("获取打印单号")
    public ApiRes<OrderPrintNumDto> getPrintCode(@RequestBody OrderMainReq req){
        return ApiRes.success(orderMainService.getPrintCode(req));
    }

}
