package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.dto.TypeSizeDto;
import com.junmp.jyzb.api.bean.query.InventorySumReq;
import com.junmp.jyzb.api.bean.query.SelectTotalNumReq;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.jyzb.service.InventorySummaryService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Inventory")
@Api(tags = "[基础信息]库存汇总模块")
public class InventorySummaryController {
    @Resource
    public InventorySummaryService inventorySummaryService;

    //根据组织机构id/单警柜id/仓库id查询出库存的汇总信息(page)
    @PostMapping(path="/GetEquipmentInfo",name="根据条件查询库存汇总信息#enable")
    @ApiOperation("根据条件查询库存汇总信息")
    public ApiRes<PageResult<InventorySummary>> getEquipmentInfo(@RequestBody InventorySumReq req) {
        return ApiRes.success(inventorySummaryService.getEquipmentInfo(req));
    }


    @PostMapping(path="/GetEquipmentSummary",name="根据条件查询库存汇总信息#enable")
    @ApiOperation("根据条件查询库存汇总信息（仅类型）")
    public ApiRes<PageResult<InventorySummary>> GetEquipmentSummary(@RequestBody @Validated(ValidationApi.page.class) InventorySumReq req) {
        return ApiRes.success(inventorySummaryService.GetEquipmentSummary(req));
    }
    @PostMapping(path="/GetEquipmentSummaryDetail",name="根据条件查询库存汇总信息#enable")
    @ApiOperation("根据条件查询库存汇总信息（号型）")
    public ApiRes<List<InventorySummary>> GetEquipmentSummaryDetail(@RequestBody InventorySumReq req) {
        return ApiRes.success(inventorySummaryService.GetEquipmentSummaryDetail(req));
    }


    @PostMapping(path="/getOne",name="获取单个库存的数量#enable")
    @ApiOperation("获取单个库存的数量")
    public ApiRes<InventorySummary> getOne(@RequestBody InventorySumReq req){
        return ApiRes.success(inventorySummaryService.getOne(req));
    }


    //根据组织机构id/单警柜id/仓库id查询出库存汇总数量以及金额(和getEquipmentInfo同时调用，汇总出符合查询条件的装备)
    @PostMapping(path="/getTotalNumberAndPrice",name="查询总金额以及各个汇总数量#enable")
    @ApiOperation("查询总金额以及各个汇总数量")
    public ApiRes<List<InventorySummary>> getTotalNumberAndPrice(@RequestBody InventorySumReq req){
        return ApiRes.success(inventorySummaryService.getTotalNumberAndPrice(req));
    }


    /**
     * 根据查询条件，查询出库存中的装备信息汇总，选择装备时使用该接口进行查询填写
     */
    //根据组织机构orgId查询出该组织机构下的仓库id
    //根据仓库id和orgId查询出库存中存在的装备typeId
    //根据仓库id，orgId,type_id 查询出装备号型sizeId
    //根据仓库id，orgId，typeId，sizeId查询出单价和对应的数量
    @PostMapping(path="/GetInventorySumInfo",name="查询出库存中的装备信息#enable")
    @ApiOperation("查询出库存中的装备信息")
    public ApiRes<List<InventorySumDto>> GetInventorySumInfo(@RequestBody InventorySumReq req){
        return ApiRes.success(inventorySummaryService.GetInventorySumInfo(req));
    }

    //调用存储过程将汇总信息进行插入
    @PostMapping(path="/insertToSummary",name="将汇总信息进行插入更新#logType=30")
    @ApiOperation("将汇总信息进行插入更新")
    public ApiRes<Boolean> insertToSummary(){
        return ApiRes.success(inventorySummaryService.insertToSummary());
    }


    @PostMapping(path="/selectTotalNum",name="根据组织机构和装备查询库存#enable")
    @ApiOperation("根据组织机构和装备查询库存")
    public ApiRes<List<InventorySumDto>> selectTotalNum(@RequestBody SelectTotalNumReq req){
        return ApiRes.success(inventorySummaryService.selectTotalNum(req));
    }


    @PostMapping(path="/selectSumByItems",name="通过条件查询库存汇总#enable")
    @ApiOperation("通过条件查询库存汇总")
    public ApiRes<List<InventorySummary>> selectSumByItems(@RequestBody SelectTotalNumReq req){
        return ApiRes.success(inventorySummaryService.selectSumByItems(req));
    }

    //首页上的装备统计数量
    @PostMapping(path="/EquipmentStatistics",name="装备数量数据统计#enable")
    @ApiOperation("装备数量数据统计")
    public ApiRes<List<InventorySummary>> EquipmentStatistics(@RequestBody InventorySumReq req){

        return ApiRes.success(inventorySummaryService.EquipmentStatistics(req));
    }

    @PostMapping(path = "/ShowInvsSummaryTypeList",name = "获取库存装备类型#enable")
    @ApiOperation("获取库存装备类型")
    public ApiRes<List<TypeSizeDto>> showInvsSummaryTypeList(@RequestBody InventorySummary req){
        return ApiRes.success(inventorySummaryService.showInvsSummaryTypeList(req));
    }

    @PostMapping(path = "/InventoryExport")
    @ApiOperation("装备导出")
    public ApiRes<Boolean> InventoryExport(@RequestBody InventorySumReq req){
        return ApiRes.success(inventorySummaryService.InventoryExport(req));
    }
    @PostMapping(path = "/export")
    @ApiOperation("装备导出")
    public ApiRes<Boolean> export(@RequestBody InventorySumReq req){
        return ApiRes.success(inventorySummaryService.export(req));
    }
}
