package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.PeriodAndDateDto;
import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.dto.fetchingDataDto.EquipmentDto;
import com.junmp.jyzb.api.bean.query.*;
import com.junmp.jyzb.api.bean.req.BatchEditingInvsReq;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.jyzb.service.*;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.*;

@RestController
@Slf4j
@RequestMapping("/Inventory")
@Api(tags = "[基础信息]库存模块")
public class InventoryController {
    @Resource
    public InventoryService inventoryService;



    //手动修改仓库数量信息，修改的是base_warehouse中的个别字段（总数，总价,入库数，出库数），是通过inventory_summary进行统计的

    @PostMapping(path="/UpdateWarehouseInsNum",name="手动重置仓库库存数量信息#logType=30")
    @ApiOperation("手动重置仓库库存数量信息")
    public ApiRes<Boolean> UpdateWarehouseInsNum(@RequestBody @Validated(ValidationApi.detail.class) WarehouseReq req){
        return ApiRes.success(inventoryService.UpdateWarehouseInsNum(req));
    }

    //手动修改单警柜数量信息，修改的是base_cabinet中的个别字段（总数，总价,入库数，出库数），是通过inventory_summary进行统计的

    @PostMapping(path="/UpdateCabinetInsNum",name="手动重置单警柜库存数量信息#logType=30")
    @ApiOperation("手动重置单警柜库存数量信息")
    public ApiRes<Boolean> UpdateCabinetInsNum(@RequestBody @Validated(ValidationApi.detail.class)CabinetReq req){
        return ApiRes.success(inventoryService.UpdateCabinetInsNum(req));
    }

    //根据Epc获取装备信息

    @PostMapping(path="/GetInvInfoByEpc",name="根据EPC列表获取装备信息#enable")
    @ApiOperation("根据EPC列表获取装备信息")
    public ApiRes<List<InventoryDto>> GetInvInfoByEpc(@RequestBody InventoryReq req){

        return ApiRes.success(inventoryService.GetInvInfoByEpc(req.getEpcList()));
    }


    //根据条件查询仓库/单警柜下的所有装备信息
    @PostMapping(path="/GetDetailByTerms",name="根据条件查询仓库#enable")
    @ApiOperation("根据条件查询仓库/单警柜下的所有装备信息")
    public ApiRes<PageResult<InventoryDto>> GetDetailByTerms(@RequestBody @Validated(ValidationApi.export.class) InventoryReq req){
        return ApiRes.success(inventoryService.GetDetailByTerms(req));
    }




    //根据装备id查询出装备的详细信息
    @PostMapping(path="/GetDetail",name="根据装备id查询装备明细信息#enable")
    @ApiOperation("根据装备id查询装备明细信息")
    public ApiRes<InventoryDto> getInventoryDetail(@RequestBody @Validated(ValidationApi.detail.class) InventoryReq req) {
        return  ApiRes.success(inventoryService.getInventoryDetail(req));
    }

    //查询箱门（cabinetBox下）所有装备简要信息列表（传递cabinetBoxId）

    @PostMapping(path="/searchEqsByBoxId",name="查询某一箱门下的所有装备简要信息#enable")
    @ApiOperation("查询某一箱门下的所有装备简要信息(list)")
    public ApiRes<List<EqsBriefDto>> searchEqsByBoxId(@RequestBody @Validated(ValidationApi.detail.class) CabinetBoxReq req){
        return ApiRes.success(inventoryService.searchEqsByBoxId(req));
    }

    //查询箱门（cabinetBox下）所有装备简要信息列表page（传递cabinetBoxId）

    @PostMapping(path="/searchEqsByBoxIdPage",name="查询某一箱门下的所有装备简要信息#enable")
    @ApiOperation("查询某一箱门下的所有装备简要信息(page)")
    public ApiRes<PageResult<EqsBriefDto>> searchEqsByBoxIdPage(@RequestBody @Validated(ValidationApi.detail.class) CabinetBoxReq req){
        return ApiRes.success(inventoryService.searchEqsByBoxIdPage(req));
    }


    //查询单警柜箱门下的汇总信息（传递cabinetBoxId）

    @PostMapping(path="/EqsByCabinetBoxId",name="查询箱门下的汇总信息#enable")
    @ApiOperation("查询箱门下的汇总信息(list)")
    public ApiRes<List<InventorySummary>> EqsByCabinetBoxId(@RequestBody @Validated(ValidationApi.detail.class)CabinetBoxReq req){
        return ApiRes.success(inventoryService.EqsByCabinetBoxId(req));
    }

    //查询单警柜箱门下的汇总信息（传递cabinetBoxId）

    @PostMapping(path="/EqsByCabinetBoxIdPage",name="查询箱门下的汇总信息#enable")
    @ApiOperation("查询箱门下的汇总信息(page)")
    public ApiRes<PageResult<InventorySummary>> EqsByCabinetBoxIdPage(@RequestBody @Validated(ValidationApi.detail.class)CabinetBoxReq req){
        return ApiRes.success(inventoryService.EqsByCabinetBoxIdPage(req));
    }

    //根据货架id查询装备信息汇总(list)

    @PostMapping(path="/ShelfInventoryList",name="根据货架id查询装备信息汇总#enable")
    @ApiOperation("根据货架id查询装备信息汇总(list)")
    public ApiRes<List<InventorySummary>> ShelfInventoryList(@RequestBody @Validated(ValidationApi.edit.class) ShelfReq req){
        return ApiRes.success(inventoryService.ShelfInventoryList(req));
    }

    //根据货架id查询装备信息汇总 (page)

    @PostMapping(path="/ShelfInventoryPage",name="根据货架id查询装备信息汇总#enable")
    @ApiOperation("根据货架id查询装备信息汇总(page)")
    public ApiRes<PageResult<InventorySummary>> ShelfInventoryPage(@RequestBody @Validated(ValidationApi.edit.class) ShelfReq req){
        return ApiRes.success(inventoryService.ShelfInventoryPage(req));
    }


    @PostMapping(path="/ShelfInventoryDetail",name="通过货架id查询每件装备信息简要#enable")
    @ApiOperation(("/通过货架id查询每件装备信息简要(list)"))
    public ApiRes<List<EqsBriefDto>> AreaInventoryDetail(@RequestBody @Validated(ValidationApi.list.class) InventoryReq req){
        return ApiRes.success(inventoryService.ShelfInventoryDetail(req));
    }


    @PostMapping(path="/ShelfEqsPage",name="通过货架id查询每件装备信息简要#enable")
    @ApiOperation(("/通过货架id查询每件装备信息简要(page)"))
    public ApiRes<PageResult<EqsBriefDto>> ShelfInventoryPage(@RequestBody @Validated(ValidationApi.list.class) InventoryReq req){
        return ApiRes.success(inventoryService.ShelfInventoryPage(req));
    }

    //根据区域id查询装备信息汇总(list)

    @PostMapping(path="/AreaInventoryList",name="根据区域id查询装备信息汇总#enable")
    @ApiOperation("根据区域id查询装备信息汇总(list)")
    public ApiRes<List<InventorySummary>> AreaInventoryList(@RequestBody @Validated(ValidationApi.edit.class) WarehouseAreaReq req){
        return ApiRes.success(inventoryService.AreaInventoryList(req));
    }

    //根据区域id查询装备信息汇总(page)
    @PostMapping(path="/AreaInventoryPage",name="根据区域id查询装备信息汇总#enable")
    @ApiOperation("根据区域id查询装备信息汇总(page)")
    public ApiRes<PageResult<InventorySummary>> AreaInventoryPage(@RequestBody @Validated(ValidationApi.edit.class) WarehouseAreaReq req){
        return ApiRes.success(inventoryService.AreaInventoryPage(req));
    }

    //导出,通过传递组织机构id，将该组织机构下的所有装备信息进行导出

    @PostMapping(path="/ExportInventoryExcel",name="组织机构装备导出#logType=30")
    @ApiOperation("组织机构装备导出")
    public void ExportInventoryExcel(@RequestBody @Validated(ValidationApi.export.class) InventoryReq req) {
        inventoryService.ExportInventoryExcel(req);
    }


    //根据条件（组织机构，装备类型id，装备型号id，装备型号名称）查询装备总数，在库数，出库数，单警柜在库数，单警柜出库数，报废数
    //查询装备数量报表

    @PostMapping(path="/GetListEquipment",name="根据条件查询数量汇总#enable")
    @ApiOperation("根据条件查询数量汇总")
    public ApiRes<List<EqsSumDto>> GetListEquipment(@RequestBody InventoryReq req){
        return ApiRes.success(inventoryService.GetListEquipment(req));
    }




    //批量信息修改（修改质保期，维保期，购入单价，生产日期，存放货架，货架位置）

    @PostMapping(path="/BatchEditingInvsInfo",name="批量信息修改#logType=30")
    @ApiOperation("批量信息修改")
    public ApiRes<Boolean> BatchEditingInvsInfo(@RequestBody BatchEditingInvsReq req){
        return ApiRes.success(inventoryService.BatchEditingInvsInfo(req));
    }




    //判断epc是否存在

    @PostMapping(path="/checkEPCList",name="判断epc是否存在#enable")
    @ApiOperation("判断epc是否存在")
    public ApiRes<List<String>> checkEPCList(@RequestBody EpcCheckReq req){
        return ApiRes.success(inventoryService.checkEPCList(req));
    }



    @PostMapping(path="/alignInventoryInfo",name="同步更新装备信息#enable")
    @ApiOperation("同步更新装备信息")
    public ApiRes<List<EquipmentDto>> alignInventoryInfo(@RequestBody InventoryReq req){
        return ApiRes.success(inventoryService.alignInventoryInfo(req));
    }

    @PostMapping(path = "/EqsImport",name = "装备导入#logType=30")
    @ApiOperation("装备导入")
    public ApiRes<Boolean> EqsImport(@RequestBody InventoryReq req) {

        return ApiRes.success(inventoryService.EqsImport(req));
    }

    //查询状态满足的装备(过质保期，报废，销毁)
    @PostMapping(path = "/EqsByState",name = "查询状态满足的装备#enable")
    @ApiOperation("查询状态满足的装备")
    public ApiRes<PageResult<InventoryDto>> EqsByState(@RequestBody InventoryReq req){

        return ApiRes.success(inventoryService.EqsByState(req));

    }

    //将装备根据质保期，维保期上产日期进行分类汇总并且返回
    @PostMapping(path = "/GetByPeriodAndDate",name="根据质保期，维保期上产日期进行分类汇总#enable")
    @ApiOperation("根据质保期，维保期上产日期进行分类汇总")
    public ApiRes<List<PeriodAndDateDto>> GetByPeriodAndDate(@RequestBody @Validated(ValidationApi.edit.class) InventoryReq req){
        return ApiRes.success(inventoryService.GetByPeriodAndDate(req));
    }


    @PostMapping(path="/EqsBindOrUnbindCabinet",name = "装备绑定、解绑箱门#logType=30")
    @ApiOperation("装备绑定箱门、解绑箱门")
    public ApiRes<String> EqsBindOrUnbindCabinet(@RequestBody PoliceEquipmentDetailReq req){
        return ApiRes.success(inventoryService.EqsBindOrUnbindCabinet(req));
    }

    @PostMapping(path="/getEqsState",name = "装备最新的出入库状态#logType=30")
    @ApiOperation("装备最新的出入库状态")
    public ApiRes<Boolean> getEqsState(@RequestBody PoliceEquipmentDetailReq req){
        return ApiRes.success(inventoryService.getEqsState(req));
    }


}
