package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.query.QuerySystemManageReq;
import com.junmp.jyzb.api.bean.req.SystemManageReq;
import com.junmp.jyzb.entity.SystemManage;
import com.junmp.jyzb.service.SystemManageService;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.common.exception.enums.DefaultBizExceptionEnum;
import com.junmp.v2.db.api.page.PageResult;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/InstitutionalManage")
@Api(tags = "[基础]制度管理模块")
public class InstitutionalManageController {
    @Resource
    private SystemManageService systemService;

    @PostMapping(path = "/add", name = "新增制度信息")
    public ApiRes<Boolean> add(@RequestBody @Validated({ValidationApi.add.class}) SystemManageReq req) {
        try {
            systemService.add(req);
            return ApiRes.success();
        } catch (Exception ex) {
            return ApiRes.failure(DefaultBizExceptionEnum.BIZ_OPTION_ERROR);
        }
    }

    @PostMapping(path = "/updateInfo", name = "更新制度信息")
    public ApiRes<Boolean> update(@RequestBody @Validated({ValidationApi.edit.class}) SystemManageReq req) {
        try {
            systemService.updateInfo(req);
            return ApiRes.success();
        } catch (Exception ex) {
            return ApiRes.failure(DefaultBizExceptionEnum.BIZ_OPTION_ERROR);
        }
    }

    @PostMapping(path = "/del", name = "删除制度信息")
    public ApiRes<Boolean> del(@RequestBody @Validated({ValidationApi.delete.class}) SystemManageReq req) {
        try {
            boolean flag = systemService.del(req);
            if (flag) {
                return ApiRes.success();
            } else {
                return ApiRes.failure(DefaultBizExceptionEnum.BIZ_OPTION_ERROR);
            }
        } catch (Exception ex) {
            return ApiRes.failure(DefaultBizExceptionEnum.BIZ_OPTION_ERROR);
        }
    }

    @PostMapping(path = "/detail", name = "获取制度信息")
    public ApiRes<SystemManage> detail(@RequestBody @Validated({ValidationApi.detail.class}) QuerySystemManageReq req) {
        try {
            return ApiRes.success(systemService.detail(req));
        } catch (Exception ex) {
            return ApiRes.failure(DefaultBizExceptionEnum.BIZ_OPTION_ERROR);
        }
    }


    @PostMapping(path = "/list", name = "制度列表信息")
    public ApiRes<List<SystemManage>> findList(@RequestBody QuerySystemManageReq req) {
        try {
            return ApiRes.success(systemService.findList(req));
        } catch (Exception ex) {
            return ApiRes.failure(ex.getMessage());
        }
    }
    @PostMapping(path = "/page", name = "制度分页信息")
    public ApiRes<PageResult<SystemManage>> findPage(@RequestBody QuerySystemManageReq req) {
        try {
            PageResult<SystemManage> page = systemService.findPage(req);
            return ApiRes.success(page);
        } catch (Exception ex) {
            return ApiRes.failure(DefaultBizExceptionEnum.BIZ_OPTION_ERROR);
        }
    }
}
