package com.junmp.jyzb.controller;

import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import com.junmp.jyzb.api.bean.dto.Api2Res;
import com.junmp.jyzb.api.bean.dto.hardWareDto.*;
import com.junmp.jyzb.api.bean.query.hardWareReq.*;
import com.junmp.jyzb.entity.Application;
import com.junmp.jyzb.entity.CabinetOutinlog;
import com.junmp.jyzb.service.HardWareService;
import com.junmp.v2.common.bean.request.ValidationApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/api")
@Api(tags = "[2.0接口重构]2.0接口模块")
public class HardWareController {
    @Resource
    private HardWareService hardWareService;

    //获取服务器时间
    @ApiOperation("获取服务器时间")
    @GetMapping("/ChannelCfg/GetServerTime")
    public Api2Res<Date> getServerTime() {
        return Api2Res.success(hardWareService.getServerTime());
    }

    //获取单警柜警员信息
    @ApiOperation("获取单警柜警员信息")
    @PostMapping("/Cabinet/GetAllPoliceByCabinet")
    public Api2Res<List<HardCabPoliceDto>> getAllPoliceByCabinet(@RequestBody @Validated(ValidationApi.detail.class) HardWareCabReq req) {
        return Api2Res.success(hardWareService.getAllPoliceByCabinet(req));
    }

    @ApiOperation("获取epc信息")
    @PostMapping("/Cabinet/GetEpcInfo")
    public Api2Res<Map<String, String>> GetEpcInfo(@RequestBody HardWareCabReq req) {
        return Api2Res.success(hardWareService.GetEpcInfo(req));
    }

    //获取装备列表
    @ApiOperation("获取装备列表")
    @PostMapping("/EquipmentDetail/GetListEquipmentDetail")
    public Api2Res<List<TypeDto>> getListEquipmentDetail(@RequestBody HardWareCabReq req) {
        return Api2Res.success(hardWareService.getListEquipmentDetail(req));
    }

    //获取装备号型列表
    @ApiOperation("获取装备号型列表")
    @PostMapping("/EquipmentSize/GetListEquipmentSizeNoSign")
    public Api2Res<List<SizeDto>> getListEquipmentSizeNoSign(@RequestBody HardWareCabReq req) {
        return Api2Res.success(hardWareService.getListEquipmentSizeNoSign(req));
    }

    //获取警员绑定装备列表
    @ApiOperation("获取警员绑定装备列表")
    @PostMapping("/Cabinet/GetBindEqu")
    public Api2Res<EqsDto> getBindEqu(@RequestBody HardWarePoliceReq req) {
        return Api2Res.success(hardWareService.getBindEqu(req));
    }

    //修改单警柜和警员信息
    @ApiOperation("修改单警柜和警员信息")
    @PostMapping("/Cabinet/UpdatePoliceAndCabinet")
    public Api2Res<Boolean> updatePoliceAndCabinet(@RequestBody @Validated(ValidationApi.detail.class) HardWarePoliceReq req) {
        return Api2Res.success(hardWareService.updatePoliceAndCabinet(req));
    }

    //获取软件版本更新
    @ApiOperation("获取软件版本更新")
    @PostMapping("/SoftUpdate/GetLastUpdate")
    public Api2Res<Application> getLastUpdate(@RequestBody @Validated(ValidationApi.edit.class) HardWarePoliceReq req) {
        return Api2Res.success(hardWareService.getLastUpdate(req));
    }

    //根据设备号和版本号获取版本更新内容以及设备号是否需要升级
    @ApiOperation("获取版本号，判断设备是否需要升级")
    @PostMapping("/SoftUpdate/GetLastUpdateAndUpgrade")
    public Api2Res<LastUpAndUpgradeDto> GetLastUpdateAndUpgrade(@RequestBody @Validated(ValidationApi.edit.class) LastUpAndUpgradeReq req) {
        return Api2Res.success(hardWareService.GetLastUpdateAndUpgrade(req));
    }


    @ApiOperation("更新成功修改设备版本号")
    @PostMapping("/SoftUpdate/UpdateCabinetVersion")
    public Api2Res<Boolean> UpdateCabinetVersion(@RequestBody @Validated(ValidationApi.detail.class) LastUpAndUpgradeReq req) {
        return Api2Res.success(hardWareService.UpdateCabinetVersion(req));
    }


    //库存
    @ApiOperation("库存")
    @PostMapping("/Cabinet/InventoryCabinet")
    public Api2Res<InvCabDto> inventoryCabinet(@RequestBody @Validated(ValidationApi.detail.class) HardWareCabReq req) {
        return Api2Res.success(hardWareService.inventoryCabinet(req));
    }


    //上报单警柜操作日志
    @ApiOperation("上报单警柜操作日志")
    @PostMapping("/Cabinet/AddWorklog")
    public Api2Res<Boolean> addWorklog(@RequestBody @Validated(ValidationApi.edit.class) HardWareCabReq req) {
        return Api2Res.success(hardWareService.addWorklog(req));
    }


    // 绑定单警柜和警员信息
    @ApiOperation("绑定单警柜和警员信息")
    @PostMapping("/Cabinet/AddPoliceAndCabinet")
    public Api2Res<Boolean> AddPoliceAndCabinet(@RequestBody @Validated(ValidationApi.list.class) HardWarePoliceReq req) {
        return Api2Res.success(hardWareService.AddPoliceAndCabinet(req));
    }

    //解绑单警柜和警员信息
    @ApiOperation("解绑单警柜和警员信息")
    @PostMapping("/Cabinet/DeletePoliceAndCabinet")
    public Api2Res<Boolean> deletePoliceAndCabinet(@RequestBody @Validated(ValidationApi.delete.class) HardWarePoliceReq req) {
        return Api2Res.success(hardWareService.deletePoliceAndCabinet(req));
    }


    //修改单警柜整柜模式
    @ApiOperation("修改单警柜整柜模式")
    @PostMapping("/Cabinet/ChangeCabinetType")
    public Api2Res<Boolean> changeCabinetType(@RequestBody @Validated(ValidationApi.updateStatus.class) HardWareCabReq req) {
        return Api2Res.success(hardWareService.changeCabinetType(req));
    }

    //上报值班归出入库日志
    @ApiOperation("上报值班出入日志")
    @PostMapping("/Cabinet/AddInOutlog")
    public Api2Res<Boolean> addInOutlog(@RequestBody AddInOutLogReq req) {
        return Api2Res.success(hardWareService.addInOutlog(req));
    }


    //公共柜箱门绑定装备
    @ApiOperation("公共柜箱门绑定装备")
    @PostMapping("/Cabinet/BindingInventory")
    public Api2Res<List<HardWareInvDto>> bindingInventory(@RequestBody @Validated(ValidationApi.export.class) HardWareCabReq req) {
        return Api2Res.success(hardWareService.bindingInventory(req));
    }


    //用户箱门绑定（公共柜）
    @ApiOperation("用户箱门绑定（公共柜）")
    @PostMapping("/Cabinet/AddPoliceAndCabinetMutiple")
    public Api2Res<Boolean> addPoliceAndCabinetMutiple(@RequestBody @Validated(ValidationApi.list.class) HardWareCabReq req) {
        return Api2Res.success(hardWareService.addPoliceAndCabinetMutiple(req));
    }


    //获取公共柜下绑定的警员信息（公共柜使用）
    @ApiOperation("获取公共柜下绑定的警员信息（公共柜使用）")
    @PostMapping("/Cabinet/GetCabinetPolicemanMultiple")
    public Api2Res<List<GetCabinetPolicemanMultipleDto>> getCabinetPolicemanMultiple(@RequestBody HardWareCabReq req) {
        return Api2Res.success(hardWareService.getCabinetPolicemanMultiple(req));
    }

    //人员绑定装备（与单警柜无关）
    @ApiOperation("人员绑定装备（与单警柜无关）")
    @PostMapping("/Cabinet/BindingInventoryByPoliceId")
    public Api2Res<Object> bindingInventoryByPoliceId(@RequestBody BindingInventoryByPoliceIdReq req) {
        Object obj = hardWareService.bindingInventoryByPoliceId(req);
        if (obj instanceof BindingInventoryByPoliceIdDto) {
            // 如果 obj 是 BindingInventoryByPoliceIdDto 类型的实例
            BindingInventoryByPoliceIdDto entity = (BindingInventoryByPoliceIdDto) obj;
            // 处理实体类对象的逻辑
            return Api2Res.failure(1999, entity);
        } else if (obj instanceof List) {
            // 如果 obj 是 List 类型的实例
            List<BindingInventoryByPoliceIdDto> list = (List<BindingInventoryByPoliceIdDto>) obj;
            return Api2Res.success(list);
        } else {
            return Api2Res.success("操作成功");
        }
    }


    //RFID离线数据上报
    @ApiOperation("RFID离线数据上报")
    @PostMapping("/Cabinet/UploadRFIDListInner")
    public Api2Res<List<UploadRFIDListInnerDto>> uploadRFIDListInner(@RequestBody UploadRFIDListInnerReq req) {
        return Api2Res.success(hardWareService.uploadRFIDListInner(req));
    }

    //RFID数据上报
    @ApiOperation("RFID数据上报")
    @PostMapping("/Cabinet/UploadRFIDInner")
    public Api2Res<List<UploadRFIDInnerDto>> uploadRFIDInner(@RequestBody @Validated(ValidationApi.edit.class) UploadRFIDInnerReq req) {
        return Api2Res.success(hardWareService.uploadRFIDInner(req));
    }

    //上传图片文件
    @ApiOperation("上传图片文件")
    @PostMapping("/ChannelCfg/UploadPic")
    public Api2Res<Boolean> uploadPic(@ModelAttribute UploadPicReq req) {
        return Api2Res.success(hardWareService.uploadPic(req));
    }


    //上传日志文件
    @ApiOperation("上传日志文件")
    @PostMapping("/ChannelCfg/UploadLog")
    public Api2Res<Boolean> uploadLog(@ModelAttribute UploadLogReq req) {
        return Api2Res.success(hardWareService.uploadLog(req));
    }


    @ApiOperation("平台获取2.0单警柜出入库信息")
    @PostMapping("/Cabinet/GetCabinetOutInLogPage")
    public ApiRes<PageResult<CabinetOutinlog>> getCabinetOutInLogPage(@RequestBody CabinetOutinlogReq req) {
        return ApiRes.success(hardWareService.getCabinetOutInLogPage(req));
    }


}
