package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.req.DeviceMsgReq;
import com.junmp.jyzb.service.DeviceMsgService;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/DeviceMsg")
@Api(tags = "[设备离线消息]设备离线消息通知模块")
public class DeviceMsgController {

    @Resource
    private DeviceMsgService deviceMsgService;
    /**
     * 设备离线消息通知
     */
    @PostMapping(path="/createDeviceMsgList",name="设备离线消息#enable")
    @ApiOperation("根据上级物资查询下一级信息")
    public ApiRes<Boolean> createDeviceMsgList(@RequestBody DeviceMsgReq req) {
        return ApiRes.success(deviceMsgService.createDeviceMsgList(req)) ;

    }
}
