package com.junmp.jyzb.cache;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.junmp.jyzb.api.bean.query.LogSummaryReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderDetailReq;
import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.jyzb.entity.Inventory;
import com.junmp.jyzb.entity.WarehouseInventory;
import com.junmp.v2.cache.AbstractRedisCache;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Component
public class OutInRecordRedisCache extends AbstractRedisCache<Object> {
    public OutInRecordRedisCache(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
    }

    @Override
    public String getCommonKeyPrefix() {
        return JYZBConstant.JYZB_TEMP_PREFIX;
    }

    //新增日志存入redis
    public void addRecord(String orderMainId, LogSummaryReq req, Long timestamp) {

        getRedisTemplate().opsForZSet().add("orderMainId:"+orderMainId, req, timestamp);
        put(orderMainId, req);
    }

    //新增装备Inv存入redis
    public void addInvRecord(String orderMainId, List<Inventory> list, Long timestamp) {

        getRedisTemplate().opsForZSet().add("addInvRecord:"+orderMainId, list, timestamp);
        put(orderMainId, list);
    }

    //新增装备InvWare存入redis
    public void addInvWareRecord(String orderMainId, List<WarehouseInventory> list, Long timestamp) {

        getRedisTemplate().opsForZSet().add("addInvWareRecord:"+orderMainId,list, timestamp);
        put(orderMainId, list);
    }

    public List<Object> getDataByTimestampRange(String orderMainId) {

        Set<Object> range = getRedisTemplate().opsForZSet().range("orderMainId:" + orderMainId, -1, -1);

        return new ArrayList<>(range);
    }


    //从redis中key所对应的装备数据（Inventory）
    public List<Inventory> addInventory(String key){
        Set<Object> range = getRedisTemplate().opsForZSet().range(key, -1, -1);
        if (!range.isEmpty()){
            Object next = range.iterator().next();
            if (next instanceof List) {
                // 强制类型转换
                List<Inventory> list = (List<Inventory>) next;
                return list;
            }else {
                return new ArrayList<>();
            }
        }else {
            return new ArrayList<>();
        }
    }

    //从redis中key所对应的装备数据（WarehouseInventory）
    public List<WarehouseInventory> addWareInventory(String key){
        Set<Object> range = getRedisTemplate().opsForZSet().range(key, -1, -1);
        if (!range.isEmpty()){
            Object next = range.iterator().next();
            if (next instanceof List) {
                // 强制类型转换
                List<WarehouseInventory> list = (List<WarehouseInventory>) next;
                return list;
            }else {
                return new ArrayList<>();
            }
        }else {
            return new ArrayList<>();
        }
    }

    //单子的流程定义id存入redis（仅调拨出库单使用）
    public void addProcessDefinitionId(String orderMainId,String processDefinitionId,Long timestamp){
        getRedisTemplate().opsForZSet().add("processId:"+orderMainId, processDefinitionId, timestamp);
    }

    //获取单子的流程定义id（仅调拨入库单使用）
    public String getProcessDefinitionIds(String orderMainId) {
        Set<Object> range = getRedisTemplate().opsForZSet().range("processId:"+orderMainId, -1, -1);
        if (!range.isEmpty()){
            Object next = range.iterator().next();
            String string = next.toString();
            return string;
        }else {
            return "";
        }
    }

    //将单子detailList进行存入redis
    public void addOrderDetailList(String orderMainId,List<UpdateOrderDetailReq> detailList,Long timestamp){
        getRedisTemplate().opsForZSet().add("detailList:"+orderMainId, detailList, timestamp);
    }
    //从redeis中取出单子
    public List<UpdateOrderDetailReq> getOrderDetailList(String orderMainId){
        Set<Object> range = getRedisTemplate().opsForZSet().range("detailList:"+orderMainId, -1, -1);
        if (!range.isEmpty()){
            Object next = range.iterator().next();
            if (next instanceof List) {
                // 强制类型转换
                List<UpdateOrderDetailReq> list = (List<UpdateOrderDetailReq>) next;
                return list;
            }else {
                return new ArrayList<>();
            }
        }else {
            return new ArrayList<>();
        }
    }


}
