package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/4/29 10:54
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Getter
public enum WsHandshakeExceptionEnum implements IExceptionEnum {


    /**
     * 握手签名值为空
     */
    WS_SIGN_EMPTY_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + 1, "握手签名值为空"),

    /**
     * 握手签名值认证失败
     */
    WS_SIGN_VERIFY_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + 2, "握手签名值认证失败");

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    WsHandshakeExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
