
package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 13:08
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Getter
public enum WsCabinetExceptionEnum implements IExceptionEnum {

    /**
     * 组织机构编号为空
     */
    WS_CABINET_ORG_ID_EMPTY(CommonConstant.DEFAULT_USER_ERROR_CODE + 1, "组织机构编号为空"),

    /**
     * 单警柜所属组织机构不存在
     */
    WS_CABINET_ORG_NOT_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE + 2, "单警柜隶属组织机构不存在"),

    /**
     * 单警柜未激活
     */
    WS_CABINET_SERIAL_NO_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE + 3, "单警柜未激活"),

    /**
     * 单警柜已激活
     */
    WS_CABINET_HAD_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE + 4, "单警柜已激活"),

    /**
     * 请求格式不正确
     */
    WS_CABINET_REQ_CMD_FORMAT_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + 5, "请求格式不正确"),

    /**
     * 不存在的指令集
     */
    WS_CABINET_CMD_NOT_EXISTS_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + 6, "不存在的指令集"),

    /**
     * 设备序号为空
     */
    WS_CABINET_DEV_SN_EMPTY(CommonConstant.DEFAULT_USER_ERROR_CODE + 7, "设备序号为空"),

    /**
     * 智能柜编号为空
     */
    WS_CABINET_ID_EMPTY_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + 8, "智能柜编号为空"),

    /**
     * 智能柜业务参数错误
     */
    WS_CABINET_BIZ_PARAM_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + 9, "智能柜业务参数错误"),
    /**
     * 智能柜业务参数错误
     */
    WS_CABINET_USER_PARAM_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE +10, "智能柜用户参数错误"),
    /**
     * 智能柜柜门编号为空
     */
    WS_CABINET_BOX_ID_EMPTY_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + 11, "智能柜柜门编号为空"),
    /**
     * 人员指纹参数错误
     */
    WS_CABINET_USER_FINGER_EMPTY_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE + 12, "智能柜人员指纹参数错误"),
    ;


    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    WsCabinetExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
