package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum WarehouseExceptionEnum implements IExceptionEnum {
    /**
     * 仓库信息不存在
     */
    WAREHOUSE_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE +17, "仓库信息不存在"),
    WAREHOUSE_IS_LOCKED(CommonConstant.DEFAULT_USER_ERROR_CODE +17, "仓库锁库中，记账失败"),
    WAREHOUSE_NAME_IS_EXIET(CommonConstant.DEFAULT_USER_ERROR_CODE +17, "仓库名称已存在，请勿提交重复名称"),
    WAREHOUSE_NAME_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE +17, "{}"),
    WAREHOUSE_NAME_OVER_TRICE(CommonConstant.DEFAULT_USER_ERROR_CODE +17, "仓库名称一次性只能导入一个，请确认仓库名称是否大于一个"),
    WAREHOUSE_EXIST_EQS(CommonConstant.DEFAULT_USER_ERROR_CODE +17, "仓库中存在装备，装备储备库状态转变失败，请确保库中没有装备后再执行此操作"),


    ;


    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    WarehouseExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
