package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum SystemManageExceptionEnum implements IExceptionEnum {

    FILE_NAME_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE +50,"制度名称已存在"),

    FILE_INFO_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE +51,"信息不存在")
    ;


    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    SystemManageExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
