package com.junmp.jyzb.api.exception.enums;


import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum PublicExceptionEnum implements IExceptionEnum {

    FILE_DEL_FAILTURE(CommonConstant.DEFAULT_USER_ERROR_CODE,"文件删除失败"),

    //设备编号重复
    APP_CODE_IS_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+11,"应用代码已存在"),
    APP_NAME_IS_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+11,"应用名称已存在"),
    APP_IS_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+11,"应用不存在，请检查应用id是否存在"),
    ;

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    PublicExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
