package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum PubOrgExceptionEnum implements IExceptionEnum {
    /**
     * 组织机构不存在
     */
    PUBORG_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+7,"组织机构不存在"),
    /**
     * 组织机构不存在或者被删除
     */
    PUBORG_NOTEXIST_OR_DEL(CommonConstant.DEFAULT_USER_ERROR_CODE+7,"组织机构不存在或者已经被删除"),

    ORG_IS_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+7,"组织机构名称已存在"),
    ORG_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+7, "{}"),
    ORG_OVER_TRICE(CommonConstant.DEFAULT_USER_ERROR_CODE+7, "装备导入组织机构名称不一致，请勿操作多个组织机构装备或同一个组织机构名称必须一致"),
    ORG_IS_NOT_MATCH(CommonConstant.DEFAULT_USER_ERROR_CODE+7, "装备导入组织机构与登录账号组织机构不匹配，请勿导入其他组织机构装备"),
    ;

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    PubOrgExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
