package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 13:08
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Getter
public enum PolicemanExceptionEnum implements IExceptionEnum {
    /**
     * 警员不存在
     */
    POLICEMAN_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+8,"警员不存在"),

    /**
     * 警员编号已经存在，警员编号重复
     *
     */
    POLICECODE_IS_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE+8,"警员编号已经存在，警员编号重复"),
    POLICENAME_IS_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE+8,"警员姓名已经存在，警员姓名重复"),
    POLICE_IS_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE+8,"警员姓名+警号已经存在，请勿重复添加"),

    /**
     * 该警员已经绑定账号
     */
    POLICEUSER_IS_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE+8,"该警员已经绑定账号"),
    /**
     * 该警员已经在审核流中，请勿重复操作
     */
    POLICE_IS_IN_EXAMINE(CommonConstant.DEFAULT_USER_ERROR_CODE+8,"该警员已经在审核流中或已经调岗完成，请勿重复操作"),
    /**
     * 该警员已经在审核流中，请勿重复操作
     */
    POLICE_IS_BUSY(CommonConstant.DEFAULT_USER_ERROR_CODE+8,"警员调岗中，无法操作"),
    POLICE_INFO_IS_EMPTY(CommonConstant.DEFAULT_USER_ERROR_CODE+8,"警员姓名或编号为空，操作失败"),
    ;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    PolicemanExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
