package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum OrderExceptionEnum implements IExceptionEnum {
    ORDER_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"单据不存在"),
    ERROR_COMMOAND(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"操作有误，无法既删除又修改"),
    ORDER_CAN_NOT_UPDATE(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"进行中的单据或已完成的单据无法修改"),
    ORDERDETAIL_ISNOT_NULL(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"记账子单据不能为空"),
    ORDERDETAIL_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"子单据不存在"),
    ORDERDETAIL_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"子单据不一致，操作失败"),
    ROLE_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"审核组织机构用户配置异常！请检查日志"),
    ORDER_CREATE_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"单子创建失败"),
    ORDER_NUM_IS_NULL(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"记账数量为空，请确认记账数量"),
    ORDER_MODIFYQUANTITY_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"记账数量错误或小于0，请确认记账数量"),
    ORDER_DEL_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"单子删除失败，只能删除待提交的单据"),
    PLAN_EXIST_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"预案单下存在尚未记账的领用出库单,无法归还"),
    ORDER_IS_RUNNING_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"单子存在正在执行的任务，请勿记账"),
    ORDER_IS_NOT_LASTER_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"单子实际出入库与最新出入库数据不匹配，不允许记账，需要更新后记账"),
    ORDER_ACCOUNTING_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+6,"记账失败"),
    ;

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    OrderExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
