package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/9/6 上午9:25
 * 作者：xuzc@junmp.com.cn
 * <br>修改记录
 * <br>修改日期 修改人 修改内容
 *
 * </pre>
 */
@Getter
public enum JyzbV2ExceptionEnum implements IExceptionEnum
{
    OPERATE_FAILED(19999,"操作失败{}"),
    OPERATE_SUCCESS(10000,"操作成功"),
    HAS_NO_LIMITS(10001,"没有操作权限"),
    ACCOUNT_NO_EXIST(10002,"没有该账户信息"),
    SIGN_ERROR(10003,"签名错误"),
    ACCOUNT_CANNOT_AUDIT(10004,"该用户无法被审核"),
    ACCOUNT_IS_AUDITED(10005,"用户已通过审核"),
    ORDER_NOT_EXIST(10006,"订单不存在"),
    ACCESSTOKEN_ERROR(10008,"请求密钥错误或过期"),
    REQUEST_DATA_ERROR(10009,"请求数据不合法"),
    ADMIN_DELETE_ERROR(100010,"不能删除超级管理员"),
    ACCOUNT_IS_EXIST(10012,"该账户已存在"),
    ACCOUNT_ISNOT_CORRECT(10013,"帐号密码不正确"),
    COMPANY_IS_EXIST(10014,"该企业已经注册"),
    AUDIT_IS_PASS(10015,"审核未通过"),
    AMONT_IS_NOT_ENOUGH(10016,"允许打印的标签数量不足"),
    CHANNEL_CODE_EXIST(10017,"通道编号已存在"),
    CABINET_ERROR(10018,"用户不存在或单警柜不存在"),
    CABINET_SET_ERROR(10018,"单警柜已被绑定"),
    NUMBER255_ERROR(10019,"号型最多添加255个"),
    APPROVE_ERROR(10020,"用户已撤回或已被审核，无法审核"),
    CHANGE_ERROR(10021,"无法修改已开始任务的领用单"),
    DELETE_ERROR(10022,"该订单不是领用单或该单据已开始"),
    SUPPLIER_ERROR(10023,"供应商码已存在"),
    UPDATE_ERROR(10024,"错误的异常修改业务"),
    POLICE_ERROR(10025,"警员不存在"),
    POLICE_C_ERROR(10125,"警号已存在"),
    EPC_ERROR(10026,"EPC或物资不存在"),
    ORDER_IS_EXIST(10027,"订单已存在"),
    ORDER_ERROR(10028,"订单号格式不正确"),
    ORGANIZATION_ERROR(10029,"组织机构不正确"),
    TIME_ERROR(10030,"时间戳失效,请求过期"),
    APPKEY_ERROR(10031,"AppKey错误"),
    API_ERROR(10032,"没有权限调用该接口"),
    MESSAGE_ERROR(10033,"认证服务网关超时"),
    EQUIPMENT_ERROR(10034,"物资不存在"),
    DELETE_USER_ERROR(10035,"请先将单警柜内与人员绑定的物资解绑"),
    WAREHOUSE_LOCK(10036,"仓库已锁定，正在盘点中"),
    WAREHOUSE_INV_EXIST(10037,"有未操作的盘点单据，请先进行处理"),
    ORDER_EXIST(10038,"已有单据在审核，请先处理待审核单据"),
    CABINET_INVENTORY_EXIST(10039,"单警柜存在物资"),
    ORDER_OPERATE_FAILED(10040,"单据操作失败"),
    ORDER_OPERATE_ERROR(10041,"单据已完成或单据不存在"),
    EPC_GEN_FAILED(10020,"EPC生成失败"),
    BASE_EXIST(10034,"基础信息已存在"),
    BOX_MARK_INVALID(10042,"无效箱标EPC"),
    NO_PROCESS(10043,"无流程信息"),
    BAG_EXIST(10044,"已有物资进行绑定，无法进行修改或删除"),
    COUNT_ERROR(10045,"实际物资数量超过预设装备包数量"),
    NAME_ERROR(10046,"名称重复"),
    MISSION_ERROR(10047,"该单据正在任务中或已有物资出入库"),
    MISSION_EXIST(10048,"存在进行中的任务"),
    ORDER_START(10049,"物资与单据状态不匹配"),
    ACTION_LIMIT(10050,"接口访问次数上限，请稍后再试"),
    WAREHOUSE_ERROR(10051,"仓库不存在"),
    CODE_ERROR(10052,"code不能为空"),
    ORGID_ERROR(10053,"组织机构Id不能为空"),
    WAREHOUSEID_ERROR(10054,"仓库Id不能为空"),
    CARDNO_ERROR(10055,"cardNo不能为空"),
    ID_ERROR(10056,"id不能为空"),
    POLICEID_ERROR(10057,"policeId不能为空"),
    FINGERLIST_ERROR(10058,"指纹列表不能为空"),
    EQUIPMENTDETAILID_ERROR(10059,"equipmentDetailId不能为空"),
    PARAM_ERROR(10060,"传递参数错误或参数为空"),
    BOXMARKEPC_ERROR(10061,"箱标epc不能为空"),
    PRINTEPCS_ERROR(10062,"打印信息epc不存在"),
    ORDERDETAIL_ERROR(10063,"单据不存在，请确保存在正确的单据"),
    ORDERMAIN_ERROR(10064,"单据已记账，入库失败"),

    ;

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    JyzbV2ExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
