package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum ConfigExceptionEnum implements IExceptionEnum {

    WAREHOUSE_DEV_NAME_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+3,"设备名称已存在，请重新修改名称后提交"),
    SOFT_IS_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE+3,"应用编码错误"),
    ;

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    ConfigExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
