package com.junmp.jyzb.api.exception.enums;

import com.baomidou.mybatisplus.annotation.IEnum;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum CabinetV2ExceptionEnum implements IExceptionEnum {

    /**
     * 单警柜未注册
     */
    CABINET_NOT_REG_EXCEPTION(10018, "单警柜未注册"),
    POLICE_INFO_NOT_EXIT(10025, "警员不存在"),
    POLICE_EXIST_EQUIPMENT(10035, "人员有绑定装备"),
    PARAM_ERROR(10018, "{}"),
    CABINETBOX_UNBIND_ERROR(10035,"箱门内存在装备，解绑失败"),
    FILE_UPLOAD_ERROR(19999,"{}"),
    INVEOTORY_INFO_ERROR(19999,"{}"),
    GENERATE_EPC_ERROR(19999,"{}"),
    IMPORT_BOX_MARK_ERROR(19999,"{}"),
    BOXING_INVENTORY_ERROR(19999,"{}"),
    POLICE_NOT_EXIST(19999,"{}"),
    GENERATE_INV_ERROR(19999,"{}"),
    GET_PRINT_LIST_ERROR(19999,"{}"),
    ;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;


    CabinetV2ExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
