
package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 13:08
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Getter
public enum CabinetExceptionEnum implements IExceptionEnum {

    /**
     * 单警柜编号重复
     */
    CABINETID_IS_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE + 2, "单警柜编号重复"),
    /**
     * 单警柜不存在
     */
    CABINET_ISNOT_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE + 2, "单警柜不存在"),

    /**
     * 传入参数错误
     */
    PARAMETER_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE, "传入参数错误不合法,或为空"),

    /**
     * 箱门id不存在
     */
    CABINETBOX_ISNOT_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE + 1, "箱门id不存在"),

    /**
     * 单警柜序列号已注册
     */
    CABINET_SERIAL_NO_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE + 4, "单警柜序列号已注册"),

    /**
     * 单警柜未连接
     */
    CABINET_DISCONNECT(CommonConstant.DEFAULT_USER_ERROR_CODE + 5, "单警柜未连接"),/**
     * 单警柜未连接
     */
    CABINET_GET_LOG_TIMEOUT(CommonConstant.DEFAULT_USER_ERROR_CODE + 5, "获取单警柜日志超时"),
    ;


    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    CabinetExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
