package com.junmp.jyzb.api.exception.enums;

import com.junmp.jyzb.api.constant.JYZBConstant;
import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum CabinetBoxExceptionEnum implements IExceptionEnum {
    /**
     * 箱子信息不存在，箱门id错误
     */
    CABINETBOX_ISNOT_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE+1,"箱子信息不存在"),
    CABINETBOX_UPDATE_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+1,"单警柜修改箱数不成功，该单景柜下面已绑人员"),
    CABINETBOX_PARAM_REQUIRE(CommonConstant.DEFAULT_USER_ERROR_CODE+1,"箱门号和人员参数需要传递一个"),
    CABINETBOX_TYPR_ERROR(CommonConstant.DEFAULT_USER_ERROR_CODE+1,"该箱门类型不是公共柜模式"),


    /**
     * 箱子已经存在
     */
    CABINETBOX_IS_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE+1,"箱子已经存在，箱门id重复"),

    BOXS_ISNOT_EXISTS(CommonConstant.DEFAULT_USER_ERROR_CODE+1, "{}"),

    ;
    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    CabinetBoxExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}

