package com.junmp.jyzb.api.enums;

import lombok.Getter;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/4/3 上午10:47
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Getter
public enum PushMsgTypeEnum {

    /**
     * 推送号型消息（装备号型发生变更）
     */
    MSG_ZB_HX(1, "推送号型消息"),

    /**
     * 推送装备类型消息（装备类型发生变更）
     */
    MSG_ZB_LX(2, "推送装备类型消息"),

    /**
     * 推送供应商和厂商类型消息（装备类供应商和厂商发生变更）
     */
    MSG_ZB_GYS(3, "推送供应商和厂商类型消息"),

    /**
     * 推送仓库消息（仓库发生变更）
     */
    MSG_ZB_CK(4, "推送仓库消息"),

    /**
     * 推送警员类型消息（警员发生变更）
     */
    MSG_JY(5, "推送警员类型消息"),

    /**
     * 推送除湿机类型消息（除湿机配置发生变更）
     */
    MSG_DEV_CSJ(6, "推送除湿机类型消息"),

    /**
     * 推送装备库存类型消息（装备库存发生变更）
     */
    MSG_ZB_KC(7, "推送装备库存类型消息"),

    /**
     * 推送通道类型消息（通道配置发生变更）
     */
    MSG_TD(8, "推送通道类型消息"),

    /**
     * 推送本地主机类型消息（本地主机发生变更）
     */
    MSG_LOCAL_HOST(9, "推送本地主机类型消息"),

    /**
     * 推送人员账号类型信息（人员账号信息发生变更）
     */
    MSG_USER(10,"推送人员账号类型信息"),
    ;

    private final Integer value;

    private final String name;


    PushMsgTypeEnum(Integer value, String name) {
        this.value = value;
        this.name = name;
    }
}
