package com.junmp.jyzb.api.bean.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentFontStyle;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.BorderStyleEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import lombok.Data;

import java.math.BigDecimal;

import static com.alibaba.excel.enums.poi.HorizontalAlignmentEnum.CENTER;

@Data
public class InventorySumVo {

    /**
     * 类型名称
     */
    @ColumnWidth(20)
    @ExcelProperty("装备名称")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String typeName;


    /**
     * 库存数量
     */
    @ColumnWidth(20)
    @ExcelProperty("装备总数")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer number;


    /**
     * 总价
     */
    @ColumnWidth(20)
    @ExcelProperty("装备总价")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private BigDecimal price;

    /**
     * 在库数
     */
    @ColumnWidth(20)
    @ExcelProperty("在库数")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer stockNumber;

    @ColumnWidth(20)
    @ExcelProperty("在库总价")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private BigDecimal stockNumberPrice;
    /**
     * 出库数量
     */
    @ColumnWidth(20)
    @ExcelProperty("在用数")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer outboundNumber;

    @ColumnWidth(20)
    @ExcelProperty("在用总价")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private BigDecimal outboundNumberPrice;
    /**
     * 销毁数量
     */
    @ColumnWidth(20)
    @ExcelProperty("销毁数")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer destructionNumber;

    @ColumnWidth(20)
    @ExcelProperty("销毁总价")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private BigDecimal destructionNumberPrice;

    /**
     * 报废数量
     */
    @ColumnWidth(20)
    @ExcelProperty("报废数")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer brokenNumber;

    @ColumnWidth(20)
    @ExcelProperty("报废总价")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private BigDecimal brokenNumberPrice;



}
