package com.junmp.jyzb.api.bean.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentFontStyle;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.BorderStyleEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import lombok.Data;

import static com.alibaba.excel.enums.poi.HorizontalAlignmentEnum.CENTER;

@Data
public class InvSumVo {
    /**
     * 类型名称
     */
    @ColumnWidth(30)
    @ExcelProperty("装备名称")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private String typeName;


    /**
     * 库存数量
     */
    @ColumnWidth(15)
    @ExcelProperty("装备总数")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer number;


    /**
     * 在库数
     */
    @ColumnWidth(10)
    @ExcelProperty("在库数")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer stockNumber;

    /**
     * 出库数量
     */
    @ColumnWidth(40)
    @ExcelProperty("在用数(非储备库在库数)")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer outboundNumber;


    /**
     * 报废数量
     */
    @ColumnWidth(10)
    @ExcelProperty("报废数")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer brokenNumber;

    /**
     * 待报废数量
     */
    @ColumnWidth(15)
    @ExcelProperty("待报废数")
    @ContentFontStyle(fontName = "宋体",fontHeightInPoints = 11)
    @ContentStyle(horizontalAlignment = CENTER ,verticalAlignment = VerticalAlignmentEnum.CENTER,
            borderLeft = BorderStyleEnum.THIN, borderBottom = BorderStyleEnum.THIN,
            borderTop = BorderStyleEnum.THIN, borderRight = BorderStyleEnum.THIN)
    private Integer expireNumber;


}
