package com.junmp.jyzb.api.bean.req;


import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class UpdateWarehouseReq extends BaseRequest {
    @NotBlank(message = "仓库主键不能为空", groups = {edit.class})
    private String id;

    @NotBlank(message = "仓库名称不能为空", groups = {add.class,edit.class})
    private String name;

    @NotBlank(message = "仓库地点不能为空", groups = {add.class,edit.class})
    private String location;

    private String phone;

    //视频地址
    private String video;

    private Date createTime;

    private Long updateTime;

    private String updateUser;

    @NotNull(message = "组织机构id不能为空", groups = {add.class,edit.class})
    private Long orgId;

    private Boolean isLocked;

    private Integer sum;

    private Integer outSum;

    private Integer inSum;

    private BigDecimal priceTotal;

    private Integer state;

    private Long orderId;

    //仓库id列表做批量操作
    private List<String> warehouseList;

    /**
     * 仓库类型（1为储备库）
     */
    private Integer warehouseType;
}
