package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class UpdateWarehouseDevReq {

    private String id;

    /**
     * 仓库id
     */
    @NotBlank(message = "仓库不能为空",groups = {ValidationApi.add.class})
    private String warehouseId;

    /**
     * 组织机构id
     */
    @NotNull(message = "组织机构id不能为空",groups = {ValidationApi.list.class, ValidationApi.add.class})
    private Long orgId;
    /**
     * Ip地址
     */
    @NotBlank(message = "ip地址不能为空",groups = {ValidationApi.add.class})
    private String devIp;

    /**
     * 端口
     */
    @NotBlank(message = "端口不能为空",groups = {ValidationApi.add.class})
    private String devPort;

    /**
     * 名称
     */
    @NotBlank(message = "设备名称不能为空",groups = {ValidationApi.add.class})
    private String devName;

    /**
     * 设备mac
     */
    private String devCode;

    /**
     * 湿度
     */
    private String warehouseSd;

    /**
     * 温度
     */
    private String warehouseWd;

    /**
     * 设定的开关
     */
    private String setState;

    /**
     * 状态：0关闭1开启
     */
    private Integer devState;

    /**
     * 设定的温度
     */
    private Integer setSd;

    private Date createTime;

    private Long updateTime;

    //rabbitmq消息有关参数
    private String api;
    private String msg;
    //rabbitmq消息有关参数
    private Integer type;

    //是否暂存（true表示暂存不会下发到本地主机，如果为空或者是为false则表示直接下发通知到本地主机）
    private Boolean flag;

    //设备类型（0除湿机，1温湿度计）
    @NotNull(message = "设备类型不能为空",groups = {ValidationApi.add.class})
    private Integer devType;

}
