package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
@EqualsAndHashCode(callSuper = true)
public class UpdateShelfReq extends BaseRequest {
    @NotBlank(message = "货架id不能为空",groups = {edit.class, delete.class})
    private String shelfId;

    private String areaId;

    @NotBlank(message = "货架名称不能为空",groups = {add.class,edit.class})
    private String shelfName;

    @NotBlank(message = "货架编号不能为空",groups = {add.class,edit.class})
    private String code;

    @NotBlank(message = "货架类型不能为空",groups = {add.class,edit.class})
    private String type;

    @NotBlank(message = "仓库id不能为空",groups = {add.class})
    private String warehouseId;

    @NotNull(message = "货架层数不能为空",groups = {add.class,edit.class})
    private Integer shelfRows;

    @NotNull(message = "货架列数不能为空",groups = {add.class,edit.class})
    private Integer shelfColumns;

    @NotNull(message = "货架排数不能为空",groups = {add.class,edit.class})
    private Integer shelfRanges;

    /**
     * 只能货架地址，普通则为空
     */
    private String url;

    @NotBlank(message = "型号信息不能为空",groups = {add.class,edit.class})
    private String sizeInfo;

    private static final long serialVersionUID = 1L;
}
