package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class UpdateOrgReq {

    /**
     * 状态
     */
    @NotNull(message = "状态不能为空", groups = {ValidationApi.edit.class})
    private Integer statusFlag;
    /**
     * 组织机构列表
     */
    @NotNull(message = "组织机构不能为空", groups = {ValidationApi.updateStatus.class})
    private List<String> orgIdList;

    @NotNull(message = "上级组织机构不能为空", groups = {ValidationApi.add.class})
    private Long orgParentId;
    @NotBlank(message = "上级所有组织机构ids不能为空",groups = {ValidationApi.add.class})
    private String orgParentIds;
    @NotBlank(message = "组织机构名称不能为空", groups = {ValidationApi.add.class, ValidationApi.edit.class})
    private String orgName;
    private String orgCode;
    private Integer isDepartment;
    @NotBlank(message = "区域名称不能为空",groups = {ValidationApi.add.class})
    private String areaName;
    @NotNull(message ="层级关系不能为空",groups = {ValidationApi.add.class})
    private Integer levelFlag;
    private String dName;
    @NotNull(message = "状态不能为空", groups = {ValidationApi.updateStatus.class})
    private Integer delFlag;
    @NotNull(message = "区域码短码不能为空",groups = {ValidationApi.add.class})
    private String findCode;
    @NotNull(message = "组织机构id不能为空", groups = {ValidationApi.edit.class, ValidationApi.detail.class})
    private Long orgId;
    //组织机构是否使用新系统（0：否，1：是）
//    @NotNull(message = "组织机构是否使用新系统（0否1是）",groups = {ValidationApi.add.class})
    private Integer isFlag;

    //经度
    private String longitude;

    //维度
    private String latitude;


    public UpdateOrgReq(String orgCode) {
        this.orgCode = orgCode;
    }
}


