package com.junmp.jyzb.api.bean.req;

import com.junmp.jyzb.api.bean.query.inAndOutRecordReq.DetailJsonReq;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 记账时的子单据请求实体类
 */
@Data
public class UpdateOrderDetailReq implements Serializable {
    /**
     * 类型
     */
    private Long  id;
    /**
     * 单据类型，out出库，in入库
     */
    private String type;
    /**
     * 类型id
     */
    private String  typeId;
    /**
     * 类型名称
     */
    private String  typeName;
    /**
     * 号型
     */
    private String  sizeId;

    private String  sizeName;

    private String  supplierId;

    private String  supplierName;

    private Integer  planNum;
    private String price;

    //计划预计金额
    private BigDecimal totalPrice;
    //实际金额
    private BigDecimal actualTotalPrice;
    private String detailJson;

    private String warehouseId;

    private String warehouseName;

    private String orderId;

    //实际数量
    private Integer actualNum;

    private String orderType;

    private Date createTime;

    private Date updateTime;

    private String createUser;

    private String updateUser;

    //记账数量
    private Integer modifyQuantity;

    /**
     * 生产日期
     */
    private String productionDate;

    /**
     * 质保期
     */
    private Integer warrantyPeriod;

    /**
     * 维保期
     */
    private Integer maintenancePeriod;

    private String remark;
    private Long orgId;
    private List<DetailJsonReq> childJson;

    //具体epc的值
    private List<InventoryReq> inventoryList;

    //Epc类型（0固定资产1库存物资非固定资产）
    private Integer property;

    //归还入库使用（物资原来仓库）
    private String oldLocationId;

    //归还入库使用（如果归还的仓库和出库仓库不一致，那么为ture将归还仓库的在库数量进行增加，出库数不变，装备总数增加，为false表示归还仓库与出库仓库一致，只需要修改在库数和出库数，并不需要修改装备总数）
    private Boolean addFlag;

    //归还入库且归还仓库与出库仓库不一致时使用（归还仓库与之前仓库不一致，那么新的仓库只会在在库数和总数上面更改，并不会对原来的出库数有所改变）
    private Integer returnNumber;

    //数量差
    private Integer subNum;


}
