package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class UpdateCabinetReq {
    /**
     * 单警柜ID
     */
    @NotBlank(message = "单警柜ID主键不能为空", groups = {ValidationApi.edit.class, ValidationApi.detail.class})
    @ApiModelProperty(value = "单警柜ID")
    private String id;

    private String cabinetId;

    /**
     * 单警柜编号
     */
    @NotBlank(message = "单警柜编号不能为空", groups = {ValidationApi.add.class, ValidationApi.edit.class, ValidationApi.detail.class})
    @ApiModelProperty(value = "单警柜编号")
    private String devSn;

    /**
     * 单警柜名称
     */
    @NotBlank(message = "单警柜名称不能为空", groups = {ValidationApi.add.class, ValidationApi.edit.class, ValidationApi.detail.class})
    @ApiModelProperty(value = "单警柜名称")
    private String name;
    /**
     * 动作来源
     */
    @ApiModelProperty(value = "动作来源")
    private String actionFrom;

    /**
     * 组织机构号
     */
    @NotNull(message = "组织机构号不能为空", groups = {ValidationApi.add.class, ValidationApi.edit.class, ValidationApi.detail.class})
    @ApiModelProperty(value = "组织机构号")
    private Long orgId;

    /**
     * 机构代码
     */
    private String orgCode;

    /**
     * 位置信息
     */

    @ApiModelProperty(value = "位置信息")
    private String location;
    /**
     * 主柜配置信息
     */

    @ApiModelProperty(value = "主柜配置信息")
    private String config;

    /**
     * 单警柜当前状态，0正常，1异常
     */
    @ApiModelProperty(value = "单警柜当前状态，0正常，1异常")
    private Integer state;


    /**
     * 更新人员
     */
    @ApiModelProperty(value = "更新人员")
    private String updateUser;
    /**
     * 如果是admin，就是本地管理员，否则就是警员信息
     */
    private String staffId;

    /**
     * 是否包含本级及下级，true为包含，false为不包含，只显示本级
     */
    @ApiModelProperty(value = "本机及下级")
    private String includeLowerLevel;


    /**
     * 箱门信息列表
     */
    private List<UpdateCabinetBoxReq> cabinetBoxList;

//    /**
//     * 箱门信息列表
//     */
//    private List<String> numList;

    /**
     * 单警柜id列表
     */
    private List<String> cabinetList;

    private Integer num;
    private Integer oldNum;

    /**
     * 版本号
     */
    private String version;

    /**
     * 是否升级（0不升级，1升级）
     */
    private Integer isUpgrade;

    /**
     * 来源，1需要同步到半山
     */
    private Integer departmentId;


}
