package com.junmp.jyzb.api.bean.req;


import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Data
public class UpdateCabinetBoxReq implements Serializable {

    /**
     * 箱门主键编号（设备端提交）
     */
    @NotBlank(message = "id不能为空",groups = {ValidationApi.edit.class})
    private String id;

    private String boxLocalId;

    /**
     * 箱门状态（正常=0、异常=1）
     */
    private Integer state;

    /**
     * 箱门错误信息
     */
    private String errorMsg;

    /**
     * 箱门名称
     */
    @NotBlank(message = "箱门名称不能为空",groups = {ValidationApi.edit.class})
    private String boxName;

    /**
     * 箱门配置文件
     */
    private String equipmentConfig;

    /**
     * 箱门类型：1单警柜，2公共柜
     */
    private Integer containType;

    /**
     * 功率
     */
    private String power;

    /**
     * 箱门编号（设备端提交）
     */
    private Integer boxNo;

    /**
     * 箱门编号集合
     */
    private List<String> boxNum;
}
