package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;
@Data
public class SystemManageReq {

    @NotEmpty(message = "id不能为空",groups = {ValidationApi.delete.class})
    private String fileId;

    /**
     * 地址
     */
    @NotEmpty(message = "地址路径不能为空",groups = {ValidationApi.add.class, ValidationApi.edit.class})
    private String url;

    /**
     * 制度名称
     */
    @NotEmpty(message = "制度名称不能为空",groups = {ValidationApi.add.class, ValidationApi.edit.class})
    private String systemName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 排序值
     */
    @NotNull(message = "排序值不能为空",groups = {ValidationApi.add.class, ValidationApi.edit.class})
    private Integer sortVal;

    /**
     * 更新时间
     */
    private Date updateTime;
}
