package com.junmp.jyzb.api.bean.req.PrintReq;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class GenerateRangeInvReq {

    @NotEmpty(message = "号型id不能为空",groups = {ValidationApi.edit.class})
    private String sizeId;

    @NotEmpty(message = "类型id不能为空",groups = {ValidationApi.edit.class})
    private String equId;

    @NotEmpty(message = "EPCList不能为空",groups = {ValidationApi.edit.class})
    private String epcListJson;

    @NotEmpty(message = "箱标Epc不能为空",groups = {ValidationApi.edit.class})
    private String epc;

    @NotEmpty(message = "供应商id不能为空",groups = {ValidationApi.edit.class})
    private String supplierId;

    @NotEmpty(message = "仓库id不能为空",groups = {ValidationApi.edit.class})
    private String warehouseId;

    private Date productTime;

    @NotNull(message = "质保周期不能为空",groups = {ValidationApi.edit.class})
    private Integer warrantyCycle;

    private BigDecimal price;

    private Date useTime;

    @NotNull(message = "维保周期不能为空",groups = {ValidationApi.edit.class})
    private Integer repairCycle;

    private String shelfId;

    private Integer shelfRange;

    private Integer shelfRow;

    private Integer shelfColumn;

    private Boolean isReloadBoxing;

    //用于获取加密数据
    private String body;


}
