package com.junmp.jyzb.api.bean.req.PrintReq;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 根据采购单信息生成EPC
 */
@Data
public class GenerateExtTagEpcReq {
    @NotEmpty(message = "供应商id不能为空",groups ={ValidationApi.edit.class})
    private String supplierId;
    @NotEmpty(message = "供应商代码不能为空",groups ={ValidationApi.edit.class})
    private String supplierCode;
    @NotEmpty(message = "供应商名称不能为空",groups ={ValidationApi.edit.class})
    private String supplierName;

    @NotEmpty(message = "子单id不能为空",groups ={ValidationApi.edit.class})
    private String detailId;


    @NotEmpty(message = "物资代码不能为空",groups ={ValidationApi.edit.class})
    private String sizeCode;

    @NotEmpty(message = "号型代码不能为空",groups ={ValidationApi.edit.class})
    private String equCode;


    @NotNull(message = "物资数量不能为空",groups ={ValidationApi.edit.class})
    private Integer quantity;

    @NotEmpty(message = "生产日期不能为空",groups ={ValidationApi.edit.class})
    private Date productTime;

    @NotNull(message = "质保周期不能为空",groups ={ValidationApi.edit.class})
    private Integer warrantyCycle;

    @NotNull(message = "维保周期不能为空",groups ={ValidationApi.edit.class})
    private Integer repairCycle;

    private BigDecimal price;

    private Date useTime;

    //货架id，行排列
    private String shelfId;
    private Integer shelfRange;
    private Integer shelfRow;
    private Integer shelfColumn;

    //用于获取加密数据
    private String body;


}
