package com.junmp.jyzb.api.bean.req.PrintReq;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class BoxingInventoryReq {
    @NotEmpty(message = "箱标不能为空",groups = {ValidationApi.detail.class,ValidationApi.edit.class})
    private String boxMarkEpc;
    @NotEmpty(message = "人员id不能为空",groups = {ValidationApi.edit.class})
    private String policeId;
    @Size(min = 1,message = "invList不能为空", groups = {ValidationApi.detail.class,ValidationApi.edit.class})
    private List<InvReq> invList;

    //用于获取加密数据
    private String body;

    @Data
    public static class InvReq{
        private String sizeId;
        private String equId;
        private String supplierId;
        private String warehouseId;
        private String epc;
        @JsonProperty("isUnboxingLabel")
        private Boolean isUnboxingLabel;
        private Date productTime;
        private Integer warrantyCycle;
        private BigDecimal price;
        private Integer repairCycle;
        private String shelfId;
        private Integer shelfRange;
        private Integer shelfRow;
        private Integer shelfColumn;
    }
}
