package com.junmp.jyzb.api.bean.req;

import com.junmp.jyzb.api.bean.dto.PlanTemplateItemDto;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * <pre>
 *
 * 描述：预案管理模板表
 * 版本：1.0.0
 * 日期：2024/6/2 15:17
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
public class PlanTemplateReq extends BaseRequest implements Serializable {
    /**
     * 模板主键
     */
    @NotNull(message = "temId不能为空", groups = {detail.class, edit.class, delete.class})
    private Long temId;

    /**
     * 模板名称
     */
    @NotBlank(message = "temName不能为空", groups = {add.class})
    private String temName;

    /**
     * 模板等级
     */
    @NotNull(message = "temGrade不能为空", groups = {add.class})
    private Integer temGrade;

    /**
     * 备注\描述
     */
    private String note;

    /**
     * 预案管理模板详情信息
     */
    @Valid
    @Size(min = 1, message = "dtoList不能为空", groups = {add.class, edit.class})
    private List<PlanTemplateItemDto> dtoList;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;
}
