package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <pre>
 *
 * 描述：预案模块表
 * 版本：1.0.0
 * 日期：2024/6/2 15:17
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */

@Data
public class PlanModuleReq extends BaseRequest implements Serializable {
    /**
     * 模块主键
     */
    @NotNull(message = "mdId不能为空", groups = {edit.class, delete.class})
    private Long mdId;

    /**
     * 模块名称
     */
    @NotBlank(message = "mdName不能为空", groups = {add.class})
    private String mdName;

    /**
     * 模块信息
     */
//    @NotBlank(message = "mdInfo不能为空", groups = {add.class})
    private String mdInfo;

    /**
     * 备注
     */
//    @NotBlank(message = "note不能为空", groups = {add.class})
    private String note;

    /**
     * 模块装备列表
     */
    @NotBlank(message = "mdList不能为空", groups = {add.class})
    private String mdList;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;
}
