package com.junmp.jyzb.api.bean.req;

import com.baomidou.mybatisplus.annotation.TableField;
import com.junmp.jyzb.api.bean.dto.PlanInitTypeDto;
import com.junmp.jyzb.api.bean.dto.PlanInitiationItemDto;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * <pre>
 *
 * 描述：预案发起表
 * 版本：1.0.0
 * 日期：2024/6/2 15:17
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
public class PlanInitiationReq extends BaseRequest implements Serializable {
    /**
     * 预案发起主键
     */
    @NotNull(message = "planId不能为空", groups = {edit.class, delete.class, onlyPlanId.class})
    private Long planId;

    /**
     * 预案名称
     */
    @NotBlank(message = "planName不能为空", groups = {add.class})
    private String planName;

    /**
     * 收物单位
     */
    @NotNull(message = "endOrgId不能为空", groups = {add.class})
    private Long endOrgId;

    /**
     * 收物单位名称
     */
    @NotBlank(message = "endOrgName不能为空", groups = {add.class})
    private String endOrgName;

    /**
     * 收物单位
     */
    @NotNull(message = "startOrgId不能为空", groups = {add.class})
    private Long startOrgId;

    /**
     * 收物单位名称
     */
    @NotBlank(message = "startOrgName不能为空", groups = {add.class})
    private String startOrgName;

    /**
     * 收物单位负责人ID
     */
    @NotNull(message = "endOrgUserId不能为空", groups = {add.class})
    private String endOrgUserId;

    /**
     * 收物单位负责人
     */
    @NotBlank(message = "endOrgUserName不能为空", groups = {add.class})
    private String endOrgUserName;



    /**
     * 发起时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 接收地点
     */
    private String place;

    /**
     * 备注\描述
     */
    private String note;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 模块主键
     */
    @NotNull(message = "temId不能为空", groups = {add.class})
    private Long temId;

    /**
     * 当前操作的组织机构
     */
    @NotNull(message = "orgId不能为空", groups = {getDetailList.class})
    private Long orgId;

    /**
     * 选中的所有装备id
     */
    @Valid
    @Size(min = 1, message = "typeList不能为空", groups = {getDetailList.class})
    private List<PlanInitTypeDto> typeList;

    /**
     * 预案单状态（0-草稿;1-待下发;2-待归还;3已完成）
     */
    private Integer state;

    /**
     * 预案管理模板详情信息
     */
    @Valid
    @Size(min = 1, message = "dtoList不能为空", groups = {add.class, edit.class})
    private List<PlanInitiationItemDto> dtoList;

    /**
     * 预案地址
     */
    private String attachmentLocation;

    public @interface getDetailList {}
    public @interface onlyPlanId {}
}
